/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.ow2.petals.kernel.api.server.PetalsServer;
import org.ow2.petals.kernel.api.server.util.SystemUtil;
import org.ow2.petals.launcher.AbstractLauncher;
import org.ow2.petals.launcher.PlatformLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPetalsLauncher
extends PlatformLauncher {
    private static final String CONFIG = "launcher.cfg";
    private static final String NAME = "name";
    private static final String URL = "url";
    private static final String JARS = "jars";
    private static final String CLASS = "class";
    private static final String MAIL = "mail";
    private static Properties props;

    @Override
    protected String getDistributionName() {
        return props.get(NAME) != null ? props.get(NAME).toString() : "Petals DSB";
    }

    protected File getJAR(String name) {
        File jarFile = null;
        File libDirectory = new File(SystemUtil.getPetalsInstallDirectory() + File.separator + "lib");
        for (File file : libDirectory.listFiles()) {
            if (!file.getName().matches(name + "-[0-9.]+\\.jar") && !file.getName().matches(name + "-[0-9.]+-SNAPSHOT\\.jar")) continue;
            jarFile = file;
            break;
        }
        return jarFile;
    }

    @Override
    protected PetalsServer loadPetalsServer() throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        List<URL> jars = this.getJarUrls(this.getJars());
        if (jars.size() == 0) {
            throw new IOException("Failed to get the PEtALS DSB bootstrap files");
        }
        List<URL> exts = this.getExtraLibs();
        if (exts != null && exts.size() > 0) {
            jars.addAll(exts);
        }
        URLClassLoader petalsKernelClassLoader = new URLClassLoader(jars.toArray(new URL[jars.size()]), AbstractLauncher.class.getClassLoader());
        Class<?> petalsKernelClass = petalsKernelClassLoader.loadClass(this.getMainServerClass());
        PetalsServer newPetalsServer = (PetalsServer)petalsKernelClass.newInstance();
        Thread.currentThread().setContextClassLoader(petalsKernelClassLoader);
        return newPetalsServer;
    }

    protected List<URL> getExtraLibs() {
        File libDirectory = new File(SystemUtil.getPetalsInstallDirectory(), "lib");
        File extFolder = new File(libDirectory, "ext");
        List<URL> exts = this.getJarUrls(extFolder);
        return exts;
    }

    private List<URL> getJarUrls(File extFolder) {
        ArrayList<URL> result = null;
        if (extFolder != null && extFolder.isDirectory()) {
            result = new ArrayList<URL>();
            File[] jars = extFolder.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.matches("\\.jar");
                }
            });
            if (jars != null) {
                for (File jar : jars) {
                    if (!jar.exists() || jar.isDirectory()) continue;
                    try {
                        result.add(jar.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    private String getJars() {
        return props.getProperty(JARS) != null ? props.getProperty(JARS) : "";
    }

    private String getMainServerClass() {
        return props.get(CLASS) != null ? props.get(CLASS).toString().trim() : null;
    }

    private List<URL> getJarUrls(String csvValue) throws FileNotFoundException, IOException, MalformedURLException {
        ArrayList<URL> jars = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(csvValue, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            File f = this.getJAR(token);
            if (f != null && f.exists() && !f.isDirectory()) {
                jars.add(f.toURI().toURL());
                continue;
            }
            System.err.println("JAR file '" + token + "' has not been found and will not be added to parent classloader");
        }
        return jars;
    }

    @Override
    protected void showBanner() {
        String title = this.getDistributionName();
        String url = this.getURL();
        String mail = this.getMail();
        int longer = title.length() > url.length() ? title.length() : url.length();
        longer = mail.length() > longer ? mail.length() : longer;
        int delta = 14;
        int size = longer + 2 * delta;
        String line = this.buildTopLine(size);
        String empty = this.buildEmptyLine(size);
        System.out.println();
        System.out.println(line);
        System.out.println(empty);
        System.out.println(this.buildTextLine(title, size));
        System.out.println(this.buildTextLine(url, size));
        System.out.println(this.buildTextLine(mail, size));
        System.out.println(empty);
        System.out.println(line);
        System.out.println();
    }

    private String buildTextLine(String text, int size) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("|");
        int pre = (size - text.length()) / 2;
        for (int i = 0; i < pre; ++i) {
            buffer.append(" ");
        }
        buffer.append(text);
        int remain = size - pre - text.length();
        for (int i = 0; i < remain; ++i) {
            buffer.append(" ");
        }
        buffer.append("|");
        return buffer.toString();
    }

    private String getURL() {
        return props.getProperty(URL) != null ? props.getProperty(URL).trim() : "";
    }

    private String getMail() {
        return props.getProperty(MAIL) != null ? props.getProperty(MAIL).trim() : "";
    }

    private String buildTopLine(int length) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        for (int i = 0; i < length; ++i) {
            sb.append("-");
        }
        sb.append(" ");
        return sb.toString();
    }

    private String buildEmptyLine(int length) {
        StringBuffer sb = new StringBuffer();
        sb.append("|");
        for (int i = 0; i < length; ++i) {
            sb.append(" ");
        }
        sb.append("|");
        return sb.toString();
    }

    static {
        File conf = new File(SystemUtil.getPetalsInstallDirectory(), "conf");
        File configFile = new File(conf, CONFIG);
        if (configFile.exists() && configFile.isFile()) {
            props = new Properties();
            try {
                props.load(new FileInputStream(configFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

