/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.task.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.objectweb.fractal.task.core.Task;
import org.objectweb.fractal.task.core.TaskMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTask
implements Task {
    private final Collection<TaskMap.TaskHole> previousTasks = new LinkedHashSet<TaskMap.TaskHole>();

    protected final void addPreviousTask(TaskMap.TaskHole task) {
        this.previousTasks.add(task);
    }

    protected final void removePreviousTask(TaskMap.TaskHole task) {
        this.previousTasks.remove(task);
    }

    protected boolean doAddDependency(TaskMap.TaskHole task, Class<?> role, Object context) {
        if (role == Task.PREVIOUS_TASK_ROLE) {
            this.addPreviousTask(task);
            return true;
        }
        return false;
    }

    protected boolean doRemoveDependency(TaskMap.TaskHole task, Class<?> role) {
        if (role == Task.PREVIOUS_TASK_ROLE) {
            this.removePreviousTask(task);
            return true;
        }
        return false;
    }

    @Override
    public void addDependency(TaskMap.TaskHole task, Class<?> role, Object context) {
        if (!this.doAddDependency(task, role, context)) {
            throw new IllegalArgumentException("Unknown dependancy role: '" + role + "'");
        }
    }

    @Override
    public void removeDependency(TaskMap.TaskHole task, Class<?> role) {
        if (!this.doRemoveDependency(task, role)) {
            throw new IllegalArgumentException("Unknown dependancy role: '" + role + "'");
        }
    }

    @Override
    public TaskMap.TaskHole[] getPreviousTasks() {
        ArrayList<TaskMap.TaskHole> tasks = new ArrayList<TaskMap.TaskHole>(this.previousTasks.size());
        for (TaskMap.TaskHole task : this.previousTasks) {
            if (task.isOptional()) continue;
            tasks.add(task);
        }
        return tasks.toArray(new TaskMap.TaskHole[0]);
    }
}

