/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.Registry;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.lifecycle.LifeCycle;
import org.ow2.petals.registry.api.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegistry
implements Registry {
    protected LifeCycle lifeCycle;
    protected String name;
    protected Context context;
    protected Log logger = LogFactory.getLog(AbstractRegistry.class);

    public final boolean delete(String key, boolean b) throws RegistryException {
        if (this.isStarted()) {
            return this.doDelete(key, b);
        }
        throw new LifeCycleException("Bad state " + (Object)((Object)this.getState()));
    }

    public abstract boolean doDelete(String var1, boolean var2) throws RegistryException;

    public final Resource get(String key, boolean b) throws RegistryException {
        if (this.isStarted()) {
            return this.doGet(key, b);
        }
        throw new RegistryException("Invalid state " + (Object)((Object)this.getState()));
    }

    public final List<Resource> getAll(String path, boolean b) throws RegistryException {
        if (this.isStarted()) {
            return this.doGetAll(path, b);
        }
        throw new RegistryException("Invalid state " + (Object)((Object)this.getState()));
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public abstract Resource doGet(String var1, boolean var2) throws RegistryException;

    public abstract List<Resource> doGetAll(String var1, boolean var2) throws RegistryException;

    public final boolean put(String key, Resource resource, boolean b) throws RegistryException {
        boolean result = false;
        if (!this.isStarted()) {
            throw new RegistryException("Invalid state " + (Object)((Object)this.getState()));
        }
        resource.setRootRegistry(this.getName());
        result = this.doPut(key, resource, b);
        return result;
    }

    public abstract boolean doPut(String var1, Resource var2, boolean var3) throws RegistryException;

    protected void setLifeCycle(LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    @Override
    public LifeCycle.STATE getState() {
        Assert.notNull(this.lifeCycle, "No lifecycle");
        return this.lifeCycle.getState();
    }

    @Override
    public void init(Context context) throws LifeCycleException {
        Assert.notNull(this.lifeCycle, "No lifecycle");
        Assert.notNull(context, "Context can not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("AbstractRegistry : init()");
        }
        this.context = context;
        this.context.init();
        this.lifeCycle.init(this.context);
    }

    @Override
    public boolean isInitialized() {
        Assert.notNull(this.lifeCycle, "No lifecycle");
        return this.lifeCycle.isInitialized();
    }

    @Override
    public boolean isNotInitialized() {
        Assert.notNull(this.lifeCycle, "No lifecycle");
        return this.lifeCycle.isNotInitialized();
    }

    @Override
    public boolean isRunning() {
        Assert.notNull(this.lifeCycle, "No lifecycle");
        return this.lifeCycle.isRunning();
    }

    @Override
    public boolean isStarted() {
        Assert.notNull(this.lifeCycle, "No lifecycle");
        return this.lifeCycle.isStarted();
    }

    @Override
    public boolean isStopped() {
        Assert.notNull(this.lifeCycle, "No lifecycle");
        return this.lifeCycle.isStopped();
    }

    @Override
    public void start() throws LifeCycleException {
        Assert.notNull(this.lifeCycle, "No lifecycle");
        this.lifeCycle.start();
    }

    @Override
    public void stop() throws LifeCycleException {
        Assert.notNull(this.lifeCycle, "No lifecycle");
        this.lifeCycle.stop();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }
}

