/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core;

import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.Information;
import org.ow2.petals.registry.api.Query;
import org.ow2.petals.registry.api.RemoteRegistry;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.lifecycle.AbstractLifeCycle;
import org.ow2.petals.registry.api.lifecycle.LifeCycle;
import org.ow2.petals.registry.api.transport.MessageSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteRegistryImpl
implements RemoteRegistry {
    private final Log log = LogFactory.getLog(RemoteRegistryImpl.class);
    private URI uri;
    private String name;
    private MessageSender messageSender;
    private final LifeCycle lifeCycle = new AbstractLifeCycle(){

        protected void doInit(Context context) throws LifeCycleException {
            RemoteRegistryImpl.this.log.debug("FIXME : Check the foreign registry at initialization?");
        }
    };

    @Override
    public Resource get(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Get the resoucre on path " + path);
        }
        if (this.messageSender == null) {
            throw new RegistryException("No message sender found to send message to remote registry");
        }
        return this.messageSender.get(path, information);
    }

    @Override
    public List<Resource> getAll(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Get all the resources under path " + path);
        }
        if (this.messageSender == null) {
            throw new RegistryException("No message sender found to send message to remote registry");
        }
        return this.messageSender.getAll(path, information);
    }

    @Override
    public boolean put(String path, Resource resource, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Put the resource " + resource);
        }
        if (this.messageSender == null) {
            throw new RegistryException("No message sender found to send message to remote registry");
        }
        return this.messageSender.put(path, resource, information);
    }

    @Override
    public boolean delete(String path, Information information) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Delete the resource at " + path);
        }
        if (this.messageSender == null) {
            throw new RegistryException("No message sender found to send message to remote registry");
        }
        return this.messageSender.delete(path, information);
    }

    @Override
    public List<Resource> query(Query query, Information info) throws RegistryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Query resources with " + query);
        }
        if (this.messageSender == null) {
            throw new RegistryException("No message sender found to send message to remote registry");
        }
        return this.messageSender.query(query, info);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public LifeCycle.STATE getState() {
        return this.lifeCycle.getState();
    }

    @Override
    public void init(Context context) throws LifeCycleException {
        this.lifeCycle.init(context);
    }

    @Override
    public boolean isInitialized() {
        return this.lifeCycle.isInitialized();
    }

    @Override
    public boolean isNotInitialized() {
        return this.lifeCycle.isNotInitialized();
    }

    @Override
    public boolean isRunning() {
        return this.lifeCycle.isRunning();
    }

    @Override
    public boolean isStarted() {
        return this.lifeCycle.isStarted();
    }

    @Override
    public boolean isStopped() {
        return this.lifeCycle.isStopped();
    }

    @Override
    public void start() throws LifeCycleException {
        this.lifeCycle.start();
    }

    @Override
    public void stop() throws LifeCycleException {
        this.lifeCycle.stop();
    }

    @Override
    public void setURI(URI uri) {
        this.uri = uri;
    }

    @Override
    public MessageSender getMessageSender() {
        return this.messageSender;
    }

    @Override
    public void setMessageSender(MessageSender messageSender) {
        this.messageSender = messageSender;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RemoteRegistryImpl [name=");
        builder.append(this.name);
        builder.append(", uri=");
        builder.append(this.uri);
        builder.append("]");
        return builder.toString();
    }
}

