/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.factory;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.RemoteRegistry;
import org.ow2.petals.registry.api.config.Configuration;
import org.ow2.petals.registry.api.config.RemoteConfiguration;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.context.ContextFactory;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.manager.IncomingManager;
import org.ow2.petals.registry.api.manager.OutgoingManager;
import org.ow2.petals.registry.api.manager.RemoteClientManager;
import org.ow2.petals.registry.api.repository.Repository;
import org.ow2.petals.registry.api.transport.MessageReceiver;
import org.ow2.petals.registry.api.transport.MessageSender;
import org.ow2.petals.registry.api.util.Assert;
import org.ow2.petals.registry.api.util.Loader;
import org.ow2.petals.registry.core.LocalRegistryImpl;
import org.ow2.petals.registry.core.RemoteRegistryImpl;
import org.ow2.petals.registry.core.factory.RepositoryFactory;

public class RegistryFactory {
    private static RegistryFactory instance;

    public static synchronized RegistryFactory getInstance() {
        if (instance == null) {
            instance = new RegistryFactory();
        }
        return instance;
    }

    private RegistryFactory() {
    }

    public LocalRegistry load(File configFile) throws RegistryException {
        Context ctx = ContextFactory.getInstance().createContext(configFile);
        return this.loadLocal(ctx);
    }

    public LocalRegistry loadLocal(Configuration configuration) throws RegistryException {
        Context ctx = ContextFactory.getInstance().createContext(configuration);
        return this.loadLocal(ctx);
    }

    public LocalRegistry loadLocal(Context context) throws RegistryException {
        Configuration config = context.getConfiguration();
        Assert.notNull(config, "The configuration can not be null");
        Assert.notNull(config.getName(), "The registry name can not be null");
        String registryName = config.getName();
        LocalRegistryImpl registry = new LocalRegistryImpl();
        registry.setName(registryName);
        registry.setContext(context);
        IncomingManager lm = null;
        if (config.getIncomingManagerClassName() != null && config.getIncomingManagerClassName().trim().length() > 0) {
            lm = Loader.loadLocalManager(config.getIncomingManagerClassName());
            Assert.notNull(lm);
            lm.setLocalRegistry(registry);
            registry.setIncomingManager(lm);
        }
        if (config.getOutgoingManagerClassName() != null && config.getOutgoingManagerClassName().trim().length() > 0) {
            OutgoingManager rm = Loader.loadRemoteManager(config.getOutgoingManagerClassName());
            Assert.notNull(rm);
            rm.setLocalRegistry(registry);
            registry.setOutgoingManager(rm);
        }
        Repository r = RepositoryFactory.load(config);
        registry.setRepository(r);
        registry.setName(registryName);
        if (config.getMessageReceiverClassName() != null && config.getMessageReceiverClassName().trim().length() > 0) {
            MessageReceiver receiver = Loader.loadMessageReceiver(config.getMessageReceiverClassName());
            receiver.setLocalManager(lm);
            registry.setMessageReceiver(receiver);
        }
        if (config.getClientManagerClassName() != null) {
            RemoteClientManager clientManager = Loader.loadRemoteClientManager(config.getClientManagerClassName());
            clientManager.setLocalRegistry(registry);
            registry.setRemoteClientManager(clientManager);
        }
        return registry;
    }

    public RemoteRegistry loadRemote(RemoteConfiguration configuration) throws RegistryException {
        Assert.notNull(configuration);
        URI uri = null;
        try {
            uri = new URI(configuration.getUri());
        }
        catch (URISyntaxException e) {
            throw new RegistryException(e);
        }
        RemoteRegistryImpl remote = new RemoteRegistryImpl();
        MessageSender messageSender = Loader.loadMessageSender(configuration.getMessageSenderClassName());
        messageSender.setURI(uri);
        remote.setMessageSender(messageSender);
        remote.getMessageSender().setURI(uri);
        remote.setName(configuration.getName());
        remote.setURI(uri);
        return remote;
    }
}

