/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.config.Configuration;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.repository.Repository;
import org.ow2.petals.registry.api.util.Assert;
import org.ow2.petals.registry.api.util.Loader;

public class RepositoryFactory {
    private static Log log = LogFactory.getLog(RepositoryFactory.class);

    private RepositoryFactory() {
    }

    public static Repository load(Configuration config) throws RegistryException {
        Assert.notNull(config);
        Assert.notNull(config.getName());
        String name = config.getName();
        Context context = Context.getContext(name);
        if (context == null) {
            context = new Context(config);
            Context.store(context);
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading repository");
        }
        Repository r = Loader.loadRepository(config.getRepositoryClassName());
        Assert.notNull(r);
        return r;
    }
}

