/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.repository.hibernate;

import java.util.Properties;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.stat.Statistics;
import org.ow2.petals.registry.api.config.DBConfiguration;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.core.repository.bo.Endpoint;

public final class HibernateHelper {
    private SessionFactory sessionFactory = null;
    static final Logger log = Logger.getLogger(HibernateHelper.class);

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Session getSession() throws RegistryException {
        if (this.sessionFactory == null) {
            log.debug((Object)"hibernate session not configured, shouldn't happen");
            throw new RegistryException("Can not find the session factory, please configure it first");
        }
        try {
            return this.sessionFactory.openSession();
        }
        catch (HibernateException e) {
            throw new RegistryException(e.getMessage());
        }
    }

    public Statistics getSessionStatistics() {
        return this.sessionFactory.getStatistics();
    }

    public void configureSession(DBConfiguration dbConfiguration) {
        try {
            AnnotationConfiguration configuration = new AnnotationConfiguration();
            Properties props = new Properties();
            props.setProperty("show_sql", "true");
            props.setProperty("hibernate.connection.driver_class", dbConfiguration.getDriver());
            props.setProperty("hibernate.connection.url", dbConfiguration.getUrl());
            props.setProperty("hibernate.connection.username", dbConfiguration.getUsername());
            props.setProperty("hibernate.connection.password", dbConfiguration.getPassword());
            props.setProperty("hibernate.dialect", dbConfiguration.getDialect());
            props.setProperty("autoReconnect", "true");
            props.setProperty("hibernate.connection.autocommit", "true");
            props.setProperty("hibernate.connection.shutdown", "true");
            props.setProperty("hibernate.hbm2ddl.auto", "update");
            props.setProperty("hibernate.query.substitutions", "true");
            if (dbConfiguration.isc3p0Enabled()) {
                props.setProperty("hibernate.connection.provider_class", "org.hibernate.connection.C3P0ConnectionProvider");
                props.setProperty("c3p0.acquire_increment", "1");
                props.setProperty("c3p0.max_size", "2");
                props.setProperty("c3p0.min_size", "1");
                props.setProperty("c3p0.max_statements", "0");
                props.setProperty("c3p0.idle_test_period", "100");
                props.setProperty("c3p0.timeout", "300");
                props.setProperty("c3p0.maxIdleTime", "300");
                props.setProperty("c3p0.maxConnectionAge", "900");
                props.setProperty("c3p0.automaticTestTable", "c3p0_conn_test");
                props.setProperty("c3p0.idleConnectionTestPeriod", "300");
            }
            if (dbConfiguration.isCachingEnabled()) {
                props.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.EhCacheProvider");
                props.setProperty("hibernate.cache.use_structured_cache", "true");
                props.setProperty("hibernate.cache.use_minimal_puts", "true");
                props.setProperty("hibernate.cache.use_query_cache", "true");
                props.setProperty("hibernate.cache.use_second_level_cache", "true");
            } else {
                props.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.NoCacheProvider");
            }
            configuration.addProperties(props);
            configuration.addAnnotatedClass(Endpoint.class);
            if (dbConfiguration.isCachingEnabled()) {
                configuration.setCacheConcurrencyStrategy(Endpoint.class.getCanonicalName(), "nonstrict-read-write");
            }
            this.sessionFactory = configuration.buildSessionFactory();
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

