/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.transport.cxf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.ow2.petals.registry.api.manager.IncomingManager;
import org.ow2.petals.registry.api.transport.MessageReceiver;
import org.ow2.petals.registry.core.ws.service.RegistryServiceImpl;

public class CXFMessageReceiver
implements MessageReceiver {
    private Server server;
    private IncomingManager localManager;
    private String address;
    private static Log logger = LogFactory.getLog(CXFMessageReceiver.class);

    public void startReceiving() {
        this.address = this.getAddress();
        logger.debug("Start receiving on " + this.address);
        JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
        RegistryServiceImpl service = new RegistryServiceImpl(this.localManager);
        svrFactory.setAddress(this.address);
        svrFactory.setServiceBean((Object)service);
        this.server = svrFactory.create();
    }

    public void stopReceiving() {
        logger.debug("Stop receiving on " + this.address);
        this.server.stop();
    }

    public IncomingManager getLocalManager() {
        return this.localManager;
    }

    public void setLocalManager(IncomingManager localManager) {
        this.localManager = localManager;
    }

    protected String getAddress() {
        return this.localManager.getLocalRegistry().getContext().getConfiguration().getMessageReceiverURL() + "/services/RegistryService";
    }
}

