/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.ws;

import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.lifecycle.AbstractLifeCycle;
import org.ow2.petals.registry.core.manager.AbstractRemoteClientManager;
import org.ow2.petals.registry.core.ws.service.RegistryClientServiceImpl;

public class WSRemoteClientManager
extends AbstractRemoteClientManager {
    private Server server;
    private String address;

    public WSRemoteClientManager() {
        this.lifeCycle = new AbstractLifeCycle(){

            protected void doInit(Context context) throws LifeCycleException {
                WSRemoteClientManager.this.address = WSRemoteClientManager.this.buildAddress(context.getConfiguration().getClientManagerURL());
            }

            protected void doStart() throws LifeCycleException {
                WSRemoteClientManager.this.logger.info("Starting remote client manager web service on " + WSRemoteClientManager.this.address);
                JaxWsServerFactoryBean svrFactory = new JaxWsServerFactoryBean();
                RegistryClientServiceImpl service = new RegistryClientServiceImpl(WSRemoteClientManager.this.getLocalRegistry());
                svrFactory.setAddress(WSRemoteClientManager.this.address);
                svrFactory.setServiceBean((Object)service);
                WSRemoteClientManager.this.server = svrFactory.create();
            }

            protected void doStop() throws LifeCycleException {
                WSRemoteClientManager.this.server.stop();
            }
        };
    }

    public LocalRegistry getLocalRegistry() {
        return this.localRegistry;
    }

    public void setLocalRegistry(LocalRegistry localRegistry) {
        this.localRegistry = localRegistry;
    }

    private String buildAddress(String rootURL) {
        return rootURL + "/services/RemoteClientService";
    }
}

