/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.ws.service;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.ws.RemoteRegistryException;
import org.ow2.petals.registry.api.ws.service.RegistryClientService;
import org.ow2.petals.registry.api.ws.to.Endpoint;
import org.ow2.petals.registry.core.ws.adapters.AdaptersManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService
public class RegistryClientServiceImpl
implements RegistryClientService {
    private static Log logger = LogFactory.getLog(RegistryClientServiceImpl.class);
    private final LocalRegistry localRegistry;

    public RegistryClientServiceImpl(LocalRegistry localRegistry) {
        this.localRegistry = localRegistry;
    }

    @Override
    public boolean delete(String path, boolean b) throws RemoteRegistryException {
        logger.debug("Got a client delete of " + path);
        try {
            return this.localRegistry.delete(path, b);
        }
        catch (RegistryException e) {
            throw new RemoteRegistryException(e.getMessage());
        }
    }

    @Override
    public Endpoint get(String path, boolean b) throws RemoteRegistryException {
        logger.debug("Got a client get of " + path);
        Endpoint result = null;
        Resource r = null;
        try {
            r = this.localRegistry.get(path, b);
        }
        catch (RegistryException e) {
            throw new RemoteRegistryException(e.getMessage());
        }
        if (r != null) {
            result = AdaptersManager.getEndpointAdapter().toWSEndpoint(r.getEndpoint());
        }
        return result;
    }

    @Override
    public boolean put(String path, Endpoint endpoint, boolean b) throws RemoteRegistryException {
        logger.debug("Got a client put into " + path);
        if (endpoint == null) {
            throw new RemoteRegistryException("Endpoint is null");
        }
        org.ow2.petals.registry.api.Endpoint e = AdaptersManager.getEndpointAdapter().toRegistryEndpoint(endpoint);
        Resource r = new Resource(e);
        try {
            return this.localRegistry.put(path, r, b);
        }
        catch (RegistryException e1) {
            throw new RemoteRegistryException(e1.getMessage());
        }
    }

    @Override
    public List<Endpoint> getAll(String path, boolean b) throws RemoteRegistryException {
        logger.debug("Got a client getall of " + path);
        ArrayList<Endpoint> result = null;
        List<Resource> r = null;
        try {
            r = this.localRegistry.getAll(path, b);
        }
        catch (RegistryException e) {
            throw new RemoteRegistryException(e.getMessage());
        }
        if (r != null) {
            result = new ArrayList<Endpoint>(r.size());
            for (Resource resource : r) {
                result.add(AdaptersManager.getEndpointAdapter().toWSEndpoint(resource.getEndpoint()));
            }
        }
        return result;
    }
}

