/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.core.ws.service;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.manager.IncomingManager;
import org.ow2.petals.registry.api.ws.RemoteRegistryException;
import org.ow2.petals.registry.api.ws.service.RegistryService;
import org.ow2.petals.registry.api.ws.to.Information;
import org.ow2.petals.registry.api.ws.to.Query;
import org.ow2.petals.registry.api.ws.to.Resource;
import org.ow2.petals.registry.core.ws.adapters.AdaptersManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService
public class RegistryServiceImpl
implements RegistryService {
    private final Log logger = LogFactory.getLog(RegistryServiceImpl.class);
    private final IncomingManager localManager;

    public RegistryServiceImpl(IncomingManager localManager) {
        this.localManager = localManager;
    }

    @Override
    public boolean delete(String path, Information information) throws RemoteRegistryException {
        this.logger.debug("Receiving a remote call to delete resource from path " + path);
        try {
            return this.localManager.delete(path, AdaptersManager.getInformationAdapter().toRegistry(information));
        }
        catch (RegistryException e) {
            throw new RemoteRegistryException(e.getMessage());
        }
    }

    @Override
    public Resource get(String path, Information information) throws RemoteRegistryException {
        this.logger.debug("Receiving a remote call to Get resource from" + path);
        Resource result = null;
        org.ow2.petals.registry.api.Resource r = null;
        try {
            r = this.localManager.get(path, AdaptersManager.getInformationAdapter().toRegistry(information));
        }
        catch (RegistryException e) {
            throw new RemoteRegistryException(e.getMessage());
        }
        if (r != null) {
            result = AdaptersManager.getResourceAdapter().toWSResource(r);
        }
        return result;
    }

    @Override
    public List<Resource> getAll(String path, Information information) throws RemoteRegistryException {
        this.logger.debug("Receiving a remote call to GetAll from " + path);
        ArrayList<Resource> result = null;
        List<org.ow2.petals.registry.api.Resource> r = null;
        try {
            r = this.localManager.getAll(path, AdaptersManager.getInformationAdapter().toRegistry(information));
        }
        catch (RegistryException e) {
            throw new RemoteRegistryException(e.getMessage());
        }
        if (r != null) {
            result = new ArrayList<Resource>(r.size());
            for (org.ow2.petals.registry.api.Resource resource : r) {
                result.add(AdaptersManager.getResourceAdapter().toWSResource(resource));
            }
        }
        return result;
    }

    @Override
    public boolean put(String path, Resource resource, Information information) throws RemoteRegistryException {
        this.logger.debug("Receiving a remote call to Put resource to path " + path);
        org.ow2.petals.registry.api.Resource r = AdaptersManager.getResourceAdapter().toRegistryResource(resource);
        try {
            return this.localManager.put(path, r, AdaptersManager.getInformationAdapter().toRegistry(information));
        }
        catch (RegistryException e) {
            throw new RemoteRegistryException(e.getMessage());
        }
    }

    @Override
    public List<Resource> query(Query query, Information information) throws RemoteRegistryException {
        this.logger.debug("Receiving a remote call to Query with " + query);
        ArrayList<Resource> result = null;
        List<org.ow2.petals.registry.api.Resource> r = null;
        try {
            r = this.localManager.query(AdaptersManager.getQueryAdapter().toRegistry(query), AdaptersManager.getInformationAdapter().toRegistry(information));
        }
        catch (RegistryException e) {
            throw new RemoteRegistryException(e.getMessage());
        }
        if (r != null) {
            result = new ArrayList<Resource>(r.size());
            for (org.ow2.petals.registry.api.Resource resource : r) {
                result.add(AdaptersManager.getResourceAdapter().toWSResource(resource));
            }
        }
        return result;
    }
}

