/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.wsnb.services.impl.topic;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.XPathDOMAnalyzer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TopicsManagerEngine {
    private static final String FLAG_TOPIC_EQUAL_TRUE = "[@wstop:topic='true']";
    private final XPathDOMAnalyzer xpathAnalyser = new XPathDOMAnalyzer();

    public List<TopicExpressionType> getTopicsAsConcreteTopExpr(TopicExpressionType topicExpression, Document supportedTopicsAsDOM) throws WsnbException {
        CopyOnWriteArrayList<TopicExpressionType> concreteTopics = new CopyOnWriteArrayList<TopicExpressionType>();
        List namespaces = topicExpression.getTopicNamespaces();
        String contentExpr = topicExpression.getContent();
        QName qExpr = QName.valueOf(contentExpr);
        if (qExpr.getNamespaceURI() != null && qExpr.getNamespaceURI().trim().length() > 0) {
            contentExpr = qExpr.getLocalPart() + ":" + qExpr.getLocalPart();
            namespaces.add(new QName(qExpr.getNamespaceURI(), qExpr.getLocalPart(), qExpr.getLocalPart()));
        } else if (contentExpr.contains(":")) {
            String prefix = contentExpr.split(":")[0];
            String localpart = contentExpr.split(":")[1];
            boolean find = false;
            for (QName ns : namespaces) {
                if (!ns.getLocalPart().equals(prefix)) continue;
                find = true;
                break;
            }
            if (!find) {
                contentExpr = localpart;
            }
        }
        NodeList topicNodes = this.lookForNodes(contentExpr, namespaces, supportedTopicsAsDOM);
        for (int i = 0; i < topicNodes.getLength(); ++i) {
            Node currentNode = topicNodes.item(i);
            if (currentNode.getNodeType() != 1) continue;
            concreteTopics.add(this.getConcreteTopicExpression(currentNode, namespaces));
        }
        return concreteTopics;
    }

    private NodeList lookForNodes(String contentExpr, List<QName> namespaces, Document supportedTopicsAsDOM) throws WsnbException {
        ConcurrentHashMap<String, String> prefixMappings = new ConcurrentHashMap<String, String>();
        for (QName qNamItem : namespaces) {
            prefixMappings.put(qNamItem.getLocalPart(), qNamItem.getNamespaceURI());
        }
        prefixMappings.put("wstop", "http://docs.oasis-open.org/wsn/t-1");
        String expressionToEvalute = "//" + contentExpr + (!contentExpr.endsWith(FLAG_TOPIC_EQUAL_TRUE) ? FLAG_TOPIC_EQUAL_TRUE : "");
        return this.xpathAnalyser.evaluate(expressionToEvalute, supportedTopicsAsDOM, prefixMappings);
    }

    private TopicExpressionType getConcreteTopicExpression(Node topicNode, List<QName> namespaces) throws WsnbException {
        TopicExpressionType concreteTopExp = null;
        Element currentElement = (Element)topicNode;
        Node currentNode = topicNode;
        String content = "";
        do {
            content = currentElement.getNodeName() + (content.length() > 0 ? "/" : "") + content;
            currentNode = currentNode.getParentNode();
            Element element = currentElement = currentNode != null ? (Element)currentNode : null;
        } while (currentElement != null && !currentElement.getNodeName().equals(WstopConstants.TOPIC_SET_QNAME.getPrefix() + ":" + WstopConstants.TOPIC_SET_QNAME.getLocalPart()));
        concreteTopExp = RefinedWsnbFactory.getInstance().createTopicExpressionType(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI);
        concreteTopExp.setContent(content);
        try {
            for (QName qNameItem : namespaces) {
                concreteTopExp.addTopicNamespace(qNameItem.getLocalPart(), new URI(qNameItem.getNamespaceURI()));
            }
        }
        catch (URISyntaxException e) {
            throw new WsnbException((Throwable)e);
        }
        return concreteTopExp;
    }

    public boolean isSupportedTopic(TopicExpressionType concreteTopicExpression, Document supportedTopicsAsDOM) throws WsnbException {
        boolean result = false;
        if (concreteTopicExpression.getDialect().equals(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI)) {
            NodeList nodes = this.lookForNodes(concreteTopicExpression.getContent(), concreteTopicExpression.getTopicNamespaces(), supportedTopicsAsDOM);
            result = nodes != null && nodes.getLength() == 1;
        }
        return result;
    }
}

