/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.generator.rest2jbi;

import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SaBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBean;
import com.ebmwebsourcing.commons.jbi.sugenerator.beans.SuBeanForSa;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiXmlGenerator;
import com.ebmwebsourcing.commons.jbi.sugenerator.utils.JbiZipper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.tools.generator.commons.Constants;
import org.ow2.petals.tools.generator.commons.Creator;
import org.ow2.petals.tools.generator.commons.CreatorFactory;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationEngine;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REST2Jbi
implements JBIGenerationEngine {
    private static final String CREATOR_CLASS_NAME = "org.ow2.petals.tools.generator.jbi.restcommons.Creator";
    private static final String SA_PREFIX = "SA-REST2JBI-";
    private final Log logger = LogFactory.getLog(REST2Jbi.class);
    private final URI restURI;
    private File outputDir;
    private final Map<String, String> extensions;
    private final SaBean saBean;
    private final List<SuBeanForSa> suBeans;
    private String endpointName;

    public REST2Jbi(URI restURI, String endpointName, Map<String, String> extensions) {
        this.restURI = restURI;
        this.endpointName = endpointName;
        this.extensions = extensions;
        this.saBean = new SaBean();
        this.suBeans = new ArrayList<SuBeanForSa>();
    }

    @Override
    public File generate() throws JBIGenerationException {
        File saDirectory;
        if (this.restURI == null) {
            throw new JBIGenerationException("REST URI is null");
        }
        String componentVersion = this.extensions.get("component.version");
        if (componentVersion == null) {
            throw new JBIGenerationException("Component version is null");
        }
        Creator c = CreatorFactory.getInstance().getCreator(componentVersion, CREATOR_CLASS_NAME);
        if (c == null) {
            throw new JBIGenerationException("Can not find a valid creator in the classpath for component version " + componentVersion);
        }
        this.logger.info((Object)("Trying to generate JBI artefact for REST Service at " + this.restURI.toString()));
        if (this.extensions != null && this.extensions.get(Constants.OUTPUT_DIR) != null) {
            this.outputDir = new File(this.extensions.get(Constants.OUTPUT_DIR));
        }
        if (this.outputDir == null) {
            this.outputDir = new File(".");
        }
        this.logger.info((Object)("The JBI artefact file will be generated in " + this.outputDir.getAbsolutePath()));
        File tmpDir = null;
        try {
            tmpDir = File.createTempFile("petalstmpdir", "txt").getParentFile();
        }
        catch (IOException e1) {
            throw new JBIGenerationException(e1);
        }
        File workDirectory = new File(tmpDir, "PETALS-REST2JBI-" + System.currentTimeMillis());
        if (!workDirectory.exists()) {
            workDirectory.mkdirs();
        }
        if (!(saDirectory = new File(workDirectory, "sa")).exists()) {
            saDirectory.mkdirs();
        }
        String saName = SA_PREFIX + System.currentTimeMillis();
        if (this.extensions != null && this.extensions.get(Constants.SA_NAME) != null) {
            saName = SA_PREFIX + this.extensions.get(Constants.SA_NAME);
        }
        this.saBean.setSaName(saName);
        this.saBean.setDescription("SA generated for the REST URL " + this.restURI.toString());
        ArrayList<File> suZipFiles = new ArrayList<File>();
        String epName = this.endpointName;
        if (epName == null) {
            epName = this.restURI.toString();
            if (epName.startsWith("http://")) {
                epName = epName.substring("http://".length(), epName.length());
            } else if (epName.startsWith("https://")) {
                epName = epName.substring("https://".length(), epName.length());
            }
            epName = epName.replaceAll("\\.", "");
            epName = epName.replaceAll("\\:", "");
            epName = epName.replaceAll("\\/", "");
            this.endpointName = epName + "Endpoint";
        }
        String prefix = this.extensions.get("rest.endpointprefix") != null ? this.extensions.get("rest.endpointprefix").toString() : "";
        this.endpointName = prefix + this.endpointName;
        String serviceName = epName + "Service";
        String interfaceName = epName + "Interface";
        String namespace = this.restURI.toString();
        String suName = "su-rest-" + this.endpointName + "-REST2JBI";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("rest.endpointaddress", this.restURI.toString());
        options.put("interface", interfaceName);
        options.put("interfacens", namespace);
        options.put("service", serviceName);
        options.put("servicens", namespace);
        options.put("endpoint", this.endpointName);
        options.put("component.version", componentVersion);
        options.put("linktype", "");
        options.put("sutype", "");
        options.put("cdk.timeout", "60000");
        options.put("cdk.wsdlfile", null);
        SuBean suProvide = c.createSUProvide(options);
        String jbiXmlForSu = JbiXmlGenerator.getInstance().generateJbiXmlFileForSu(suProvide);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Generated JBI :");
            this.logger.info((Object)jbiXmlForSu);
        }
        File suFile = null;
        File jbiSu = null;
        try {
            File tempSuDirectory = new File(workDirectory, suName);
            if (!tempSuDirectory.exists()) {
                tempSuDirectory.mkdirs();
            }
            if (!(jbiSu = new File(tempSuDirectory, "jbi.xml")).exists()) {
                jbiSu.createNewFile();
            }
            FileWriter writer = new FileWriter(jbiSu);
            writer.write(jbiXmlForSu);
            writer.close();
            JbiZipper jbiZipper = JbiZipper.getInstance();
            ArrayList<File> rootFiles = new ArrayList<File>();
            rootFiles.add(jbiSu);
            suFile = new File(this.outputDir, suName + ".zip");
            suZipFiles.add(jbiZipper.createSuZipFile(suFile, rootFiles));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            throw new JBIGenerationException(e);
        }
        SuBeanForSa suBeanForSa = new SuBeanForSa(suProvide);
        suBeanForSa.setZipArtifact(suFile.getName());
        suBeanForSa.setSuName(suName);
        suBeanForSa.setComponentName(c.getComponentName());
        this.suBeans.add(suBeanForSa);
        jbiSu.delete();
        this.saBean.setSus(this.suBeans);
        String jbiXmlForSa = JbiXmlGenerator.getInstance().generateJbiXmlFileForSa(this.saBean);
        File jbiSa = new File(saDirectory, "jbi.xml");
        File saZipFile = null;
        try {
            byte[] utf8 = jbiXmlForSa.getBytes("UTF-8");
            FileWriter writer = new FileWriter(jbiSa);
            writer.write(new String(utf8));
            writer.close();
            JbiZipper jbiZipper = JbiZipper.getInstance();
            File saFile = new File(this.outputDir, saName + ".zip");
            saZipFile = jbiZipper.createSaZipFile(saFile, suZipFiles, jbiSa);
        }
        catch (IOException e) {
            throw new JBIGenerationException(e);
        }
        jbiSa.delete();
        for (File su : suZipFiles) {
            if (!su.exists()) continue;
            su.delete();
        }
        return saZipFile;
    }
}

