/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitoring.service;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.monitoring.service.ConfigurationService;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ConfigurationService.class)})
public class FileConfigurationServiceImpl
implements BindingController,
LifeCycleController,
ConfigurationService {
    private Logger logger;
    private org.ow2.petals.kernel.api.log.Logger log;
    @Requires(name="configuration", signature=org.ow2.petals.kernel.configuration.ConfigurationService.class)
    private org.ow2.petals.kernel.configuration.ConfigurationService configurationService;
    private String baseURL;
    private String adminURL;
    private String listenerURL;
    private boolean active;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.load();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
        this.log.start();
    }

    protected void load() {
        File file = new File(this.configurationService.getContainerConfiguration().getRootDirectoryPath(), "conf");
        File file2 = new File(file, "monitoring.cfg");
        if (file2.exists() && file2.isFile()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file2));
                this.active = Boolean.getBoolean(properties.getProperty("monitoring.active", "false"));
                this.adminURL = properties.getProperty("monitoring.admin", "http://localhost:8085/services/adminExternalEndpoint");
                this.baseURL = properties.getProperty("monitoring.base", "http://localhost:8085/services/");
                if (!this.baseURL.endsWith("/")) {
                    this.baseURL = String.valueOf(this.baseURL) + "/";
                }
                this.listenerURL = properties.getProperty("monitoring.listener");
            }
            catch (Exception exception) {
                this.log.warning((Object)exception.getMessage());
            }
        } else {
            this.log.warning((Object)"The monitoring configuration file has not been found : monitoring.cfg");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getAdminURL() {
        return this.adminURL;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public String getListenerURL() {
        return this.listenerURL;
    }

    public boolean isActive() {
        return this.active;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!org.ow2.petals.kernel.configuration.ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + org.ow2.petals.kernel.configuration.ConfigurationService.class.getName());
            }
            this.configurationService = (org.ow2.petals.kernel.configuration.ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

