/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitoring.service.listeners;

import java.util.ArrayList;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.kernel.api.messaging.RegistryListener;
import org.petalslink.dsb.kernel.monitoring.service.ConfigurationService;
import org.petalslink.dsb.monitoring.api.MonitoringAdminClient;
import org.petalslink.dsb.monitoring.api.MonitoringClientFactory;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RegistryListener.class)})
public class RegistryListenerImpl
implements BindingController,
LifeCycleController,
RegistryListener {
    @Requires(name="monitoringconfiguration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="monitoringclientfactory", signature=MonitoringClientFactory.class)
    private MonitoringClientFactory factory;
    private Logger logger;
    protected org.ow2.petals.kernel.api.log.Logger log;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void onRegister(ServiceEndpoint serviceEndpoint) throws DSBException {
        MonitoringAdminClient monitoringAdminClient;
        if (!this.configurationService.isActive()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Monitoring is not active, do not register endpoint");
            }
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Notifying monitoring Bus that endpoint has been registered : " + serviceEndpoint));
        }
        if ((monitoringAdminClient = this.getClient()) == null) {
            this.log.warning((Object)"Can not get any client to send message to monitoring layer");
            return;
        }
        try {
            monitoringAdminClient.createMonitoringEndpoint(serviceEndpoint);
        }
        catch (Exception exception) {
            if (this.log.isDebugEnabled()) {
                this.log.warning((Object)"Can not add monitoring endpoint", (Throwable)exception);
            }
            this.log.warning((Object)"Can not add monitoring endpoint");
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private MonitoringAdminClient getClient() {
        return this.factory.getMonitoringAdminClient();
    }

    public void onUnregister(ServiceEndpoint serviceEndpoint) throws DSBException {
        MonitoringAdminClient monitoringAdminClient;
        if (!this.configurationService.isActive()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Monitoring is not active, do not unregister endpoint");
            }
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Notifying monitoring Bus that endpoint has been unregistered : " + serviceEndpoint));
        }
        if ((monitoringAdminClient = this.getClient()) == null) {
            this.log.warning((Object)"Can not get any client to send message to monitoring layer");
            return;
        }
        try {
            monitoringAdminClient.deleteMonitoringEndpoint(serviceEndpoint);
        }
        catch (Exception exception) {
            this.log.warning((Object)"Can not delete monitoring endpoint", (Throwable)exception);
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public String getName() {
        return "MonitoringRegistryListener";
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("monitoringconfiguration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("monitoringclientfactory")) {
            if (!MonitoringClientFactory.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + MonitoringClientFactory.class.getName());
            }
            this.factory = (MonitoringClientFactory)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("monitoringconfiguration");
        arrayList.add("monitoringclientfactory");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("monitoringconfiguration")) {
            return this.configurationService;
        }
        if (string.equals("monitoringclientfactory")) {
            return this.factory;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("monitoringconfiguration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("monitoringclientfactory")) {
            this.factory = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

