/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitoring.service.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Cardinality;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.ReceiverModule;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.kernel.messaging.router.RouterModuleManager;
import org.petalslink.dsb.kernel.messaging.router.SenderModule;

@FractalComponent
public class ModuleRegistration
implements BindingController,
LifeCycleController {
    private static final String RECEIVERMODULE_FRACTAL_PREFIX = "receivermodule";
    private static final String SENDERMODULE_FRACTAL_PREFIX = "sendermodule";
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="routermodulemanager", signature=RouterModuleManager.class)
    protected RouterModuleManager routerModuleManager;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="receivermodule", signature=ReceiverModule.class)
    private final Map<String, Object> receivers = new Hashtable<String, Object>();
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="sendermodule", signature=org.ow2.petals.jbi.messaging.routing.module.SenderModule.class)
    private final Map<String, Object> senders = new Hashtable<String, Object>();
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycleListener
    public void loadModules() {
        Object object;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Ack to add modules to manager");
        }
        for (String string : this.senders.keySet()) {
            object = this.senders.get(string);
            if (object == null || !(object instanceof org.ow2.petals.jbi.messaging.routing.module.SenderModule)) continue;
            this.addModule(string, (org.ow2.petals.jbi.messaging.routing.module.SenderModule)object);
        }
        for (String string : this.receivers.keySet()) {
            object = this.receivers.get(string);
            if (object == null || !(object instanceof ReceiverModule)) continue;
            this.addModule(string, (ReceiverModule)object);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    void addModule(final String string, final org.ow2.petals.jbi.messaging.routing.module.SenderModule senderModule) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Adding sender module %s to manager", string));
        }
        this.routerModuleManager.add(new SenderModule(){

            public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchange messageExchange) throws RoutingException {
                senderModule.electEndpoints(map, componentContext, messageExchange);
            }

            public String getName() {
                return string;
            }

            public String getDescription() {
                return senderModule.getClass().getName();
            }
        });
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    void addModule(final String string, final ReceiverModule receiverModule) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Adding receiver module %s to manager", string));
        }
        this.routerModuleManager.add(new org.petalslink.dsb.kernel.messaging.router.ReceiverModule(){

            public boolean receiveExchange(MessageExchange messageExchange, ComponentContext componentContext) throws RoutingException {
                return receiverModule.receiveExchange(messageExchange, componentContext);
            }

            public String getName() {
                return string;
            }

            public String getDescription() {
                return receiverModule.getClass().getName();
            }
        });
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("routermodulemanager")) {
            if (!RouterModuleManager.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterModuleManager.class.getName());
            }
            this.routerModuleManager = (RouterModuleManager)object;
            return;
        }
        if (string.startsWith(RECEIVERMODULE_FRACTAL_PREFIX)) {
            if (!ReceiverModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ReceiverModule.class.getName());
            }
            this.receivers.put(string, object);
            return;
        }
        if (string.startsWith(SENDERMODULE_FRACTAL_PREFIX)) {
            if (!org.ow2.petals.jbi.messaging.routing.module.SenderModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + org.ow2.petals.jbi.messaging.routing.module.SenderModule.class.getName());
            }
            this.senders.put(string, object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("routermodulemanager");
        arrayList.addAll((Collection)this.receivers.keySet());
        arrayList.addAll((Collection)this.senders.keySet());
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("routermodulemanager")) {
            return this.routerModuleManager;
        }
        if (string.startsWith(string)) {
            return this.receivers.get(string);
        }
        if (string.startsWith(string)) {
            return this.senders.get(string);
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("routermodulemanager")) {
            this.routerModuleManager = null;
            return;
        }
        if (this.receivers.containsKey(string)) {
            this.receivers.remove(string);
            return;
        }
        if (this.senders.containsKey(string)) {
            this.senders.remove(string);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

