/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitoring.service.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.easywsdl.schema.api.XmlException;
import org.ow2.easywsdl.schema.util.SourceHelper;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.ReceiverModule;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.kernel.monitoring.service.ConfigurationService;
import org.petalslink.dsb.kernel.monitoring.service.time.TimeStamperHandler;
import org.petalslink.dsb.monitoring.api.MonitoringClient;
import org.petalslink.dsb.monitoring.api.MonitoringClientFactory;
import org.petalslink.dsb.monitoring.api.ReportBean;
import org.petalslink.dsb.monitoring.api.ReportListBean;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="reportSender", signature=SenderModule.class), @Interface(name="reportReceiver", signature=ReceiverModule.class)})
public class MonitoringModule
implements BindingController,
LifeCycleController,
ReceiverModule,
SenderModule {
    private LoggerFactory loggerFactory;
    private org.ow2.petals.kernel.api.log.Logger log;
    private Logger logger;
    @Requires(name="monitoringconfiguration", signature=ConfigurationService.class)
    private ConfigurationService configuration;
    @Requires(name="monitoringclientfactory", signature=MonitoringClientFactory.class)
    private MonitoringClientFactory monitoringClientFactory;
    private final Map<String, Integer> map = Collections.synchronizedMap(new HashMap());

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchange messageExchange) throws RoutingException {
        this.log.call();
        if (!this.configuration.isActive()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Monitoring is not active, do not report time");
            }
            return;
        }
        try {
            ReportListBean reportListBean = this.createReportListFromExchange(messageExchange);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"In Report Module electDestinations");
            }
            if (reportListBean.getReports().size() > 0) {
                this.sendRawReport(reportListBean);
            }
        }
        catch (Exception exception) {
            throw new RoutingException((Throwable)exception);
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean receiveExchange(MessageExchange messageExchange, ComponentContext componentContext) throws RoutingException {
        if (!this.configuration.isActive()) {
            if (!this.log.isDebugEnabled()) return true;
            this.log.debug((Object)"Monitoring is not active, do not report time");
            return true;
        }
        if (messageExchange != null) {
            try {
                ReportListBean reportListBean;
                if (this.log.isDebugEnabled()) {
                    this.log.info((Object)"In Report Module: receiveExchange");
                }
                if ((reportListBean = this.createReportListFromExchange(messageExchange)).getReports().size() <= 0) return true;
                this.sendReport(reportListBean, messageExchange.getEndpoint().getEndpointName());
                return true;
            }
            catch (Exception exception) {
                throw new RoutingException((Throwable)exception);
            }
        } else {
            this.log.warning((Object)"ERROR: TIMEOUT");
            throw new RoutingException("Impossible to create report");
        }
    }

    private void sendReport(ReportListBean reportListBean, String string) throws Exception {
        MonitoringClient monitoringClient = this.getMonitoringClient(string);
        if (monitoringClient == null) {
            throw new DSBException("Can not get any client to send report to monitoring layer for endpoint %s", new Object[]{string});
        }
        monitoringClient.send(reportListBean);
    }

    private void sendRawReport(ReportListBean reportListBean) throws Exception {
        MonitoringClient monitoringClient = this.monitoringClientFactory.getRawMonitoringClient();
        if (monitoringClient == null) {
            throw new DSBException("Can not get any client to send RAW report to monitoring layer");
        }
        monitoringClient.send(reportListBean);
    }

    private MonitoringClient getMonitoringClient(String string) {
        return this.monitoringClientFactory.getMonitoringClient(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ReportListBean createReportListFromExchange(MessageExchange messageExchange) throws DSBException {
        ReportListBean reportListBean = new ReportListBean();
        try {
            Object object;
            Object object2;
            ReportBean reportBean;
            Object object3;
            if (!MessageExchange.Role.CONSUMER.equals(messageExchange.getRole())) return reportListBean;
            if ((MessageExchange.IN_ONLY_PATTERN.equals(messageExchange.getPattern()) && !messageExchange.isTerminated() || (MessageExchange.IN_OUT_PATTERN.equals(messageExchange.getPattern()) || MessageExchange.IN_OPTIONAL_OUT_PATTERN.equals(messageExchange.getPattern())) && messageExchange.getMessage("out") == null && !messageExchange.isTerminated()) && !this.map.containsKey(messageExchange.getExchangeId())) {
                if (messageExchange.getMessage("in").getContent() == null) {
                    this.map.put(messageExchange.getExchangeId(), 0);
                } else if (messageExchange.getMessage("in").getContent() instanceof StreamSource) {
                    this.map.put(messageExchange.getExchangeId(), ((StreamSource)messageExchange.getMessage("in").getContent()).getInputStream().available());
                } else {
                    if (!(messageExchange.getMessage("in").getContent() instanceof DOMSource)) throw new DSBException("Source unknown: " + messageExchange.getMessage("in").getContent().getClass());
                    object3 = SourceHelper.convertDOMSource2InputSource((DOMSource)((DOMSource)messageExchange.getMessage("in").getContent()));
                    this.map.put(messageExchange.getExchangeId(), ((InputSource)object3).getByteStream().available());
                }
            }
            if (MessageExchange.IN_ONLY_PATTERN.equals(messageExchange.getPattern()) && messageExchange.isTerminated()) {
                object3 = new ReportBean();
                object3.setType("t1");
                this.setSOACommonInformation(messageExchange, (ReportBean)object3);
                object3.setDate(TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateClientIn());
                object3.setContentLength((long)this.map.remove(messageExchange.getExchangeId()).intValue());
                reportListBean.getReports().add(object3);
                reportBean = new ReportBean();
                reportBean.setType("t2");
                this.setSOACommonInformation(messageExchange, reportBean);
                reportBean.setDate(TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateProviderIn());
                if (messageExchange.getMessage("in") != null) {
                    if (messageExchange.getMessage("in").getContent() instanceof StreamSource && (StreamSource)messageExchange.getMessage("in").getContent() != null && ((StreamSource)messageExchange.getMessage("in").getContent()).getInputStream() != null) {
                        reportBean.setContentLength((long)((StreamSource)messageExchange.getMessage("in").getContent()).getInputStream().available());
                    } else {
                        if (!(messageExchange.getMessage("in").getContent() instanceof DOMSource) || (DOMSource)messageExchange.getMessage("in").getContent() == null) throw new DSBException("Source unknown");
                        object2 = SourceHelper.convertDOMSource2InputSource((DOMSource)((DOMSource)messageExchange.getMessage("in").getContent()));
                        reportBean.setContentLength((long)((InputSource)object2).getByteStream().available());
                    }
                } else {
                    reportBean.setContentLength(-1L);
                }
                reportListBean.getReports().add(reportBean);
                object2 = new ReportBean();
                object3.setType("t3");
                this.setSOACommonInformation(messageExchange, (ReportBean)object2);
                object2.setDate(TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateProviderOut());
                object2.setContentLength(0L);
                object2.setException(false);
                reportListBean.getReports().add(object2);
                object = new ReportBean();
                object3.setType("t4");
                this.setSOACommonInformation(messageExchange, (ReportBean)object);
                object.setDate(TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateClientOut());
                object.setContentLength(0L);
                object.setException(false);
                reportListBean.getReports().add(object);
            }
            if (!MessageExchange.IN_OUT_PATTERN.equals(messageExchange.getPattern()) && !MessageExchange.IN_OPTIONAL_OUT_PATTERN.equals(messageExchange.getPattern()) || messageExchange.getMessage("out") == null && messageExchange.getFault() == null && messageExchange.getError() == null) return reportListBean;
            object3 = new ReportBean();
            object3.setType("t1");
            this.setSOACommonInformation(messageExchange, (ReportBean)object3);
            object3.setDate(TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateClientIn());
            object3.setContentLength((long)this.map.remove(messageExchange.getExchangeId()).intValue());
            reportListBean.getReports().add(object3);
            reportBean = new ReportBean();
            reportBean.setType("t2");
            this.setSOACommonInformation(messageExchange, reportBean);
            reportBean.setDate(TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateProviderIn());
            reportBean.setContentLength(reportBean.getContentLength());
            reportListBean.getReports().add(reportBean);
            object2 = new ReportBean();
            object2.setType("t3");
            this.setSOACommonInformation(messageExchange, (ReportBean)object2);
            object2.setDate(TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateProviderOut());
            if (messageExchange.getMessage("out") != null) {
                if (messageExchange.getMessage("out").getContent() instanceof StreamSource && (StreamSource)messageExchange.getMessage("out").getContent() != null && ((StreamSource)messageExchange.getMessage("out").getContent()).getInputStream() != null) {
                    object2.setContentLength((long)((StreamSource)messageExchange.getMessage("out").getContent()).getInputStream().available());
                } else {
                    if (!(messageExchange.getMessage("out").getContent() instanceof DOMSource) || (DOMSource)messageExchange.getMessage("out").getContent() == null) throw new DSBException("Source unknown: " + messageExchange.getMessage("out").getContent());
                    object = SourceHelper.convertDOMSource2InputSource((DOMSource)((DOMSource)messageExchange.getMessage("out").getContent()));
                    object2.setContentLength((long)((InputSource)object).getByteStream().available());
                }
            } else {
                object2.setContentLength(0L);
            }
            if (messageExchange.getFault() != null || messageExchange.getError() != null) {
                object2.setException(true);
            } else {
                object2.setException(false);
            }
            reportListBean.getReports().add(object2);
            object = new ReportBean();
            object3.setType("t4");
            this.setSOACommonInformation(messageExchange, (ReportBean)object);
            object.setDate(TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateClientOut());
            object.setContentLength(object2.getContentLength());
            if (messageExchange.getFault() != null || messageExchange.getError() != null) {
                object.setException(true);
            } else {
                object.setException(false);
            }
            reportListBean.getReports().add(object);
            return reportListBean;
        }
        catch (IOException iOException) {
            throw new DSBException((Throwable)iOException);
        }
        catch (XmlException xmlException) {
            throw new DSBException((Throwable)xmlException);
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("monitoringconfiguration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configuration = (ConfigurationService)object;
            return;
        }
        if (string.equals("monitoringclientfactory")) {
            if (!MonitoringClientFactory.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + MonitoringClientFactory.class.getName());
            }
            this.monitoringClientFactory = (MonitoringClientFactory)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("monitoringconfiguration");
        arrayList.add("monitoringclientfactory");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("monitoringconfiguration")) {
            return this.configuration;
        }
        if (string.equals("monitoringclientfactory")) {
            return this.monitoringClientFactory;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("monitoringconfiguration")) {
            this.configuration = null;
            return;
        }
        if (string.equals("monitoringclientfactory")) {
            this.monitoringClientFactory = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private void setSOACommonInformation(MessageExchange messageExchange, ReportBean reportBean) {
        if (messageExchange.getProperty("wsa:to") != null) {
            boolean cfr_ignored_0 = messageExchange.getProperty("wsa:to") instanceof String;
        }
        reportBean.setExchangeId(messageExchange.getExchangeId());
        if (messageExchange.getService() != null) {
            reportBean.setServiceName(messageExchange.getService().toString());
        }
        if (messageExchange.getEndpoint() != null) {
            reportBean.setEndpoint(messageExchange.getEndpoint().getEndpointName());
        }
        if (messageExchange.getOperation() != null) {
            reportBean.setOperation(messageExchange.getOperation().toString());
        }
        if (messageExchange.getInterfaceName() != null) {
            reportBean.setItf(messageExchange.getInterfaceName().toString());
        }
        if (messageExchange.getConsumerEndpoint().toString() != null) {
            reportBean.setConsumer(messageExchange.getConsumerEndpoint().toString());
        } else {
            reportBean.setConsumer(messageExchange.getConsumerEndpoint().toString());
        }
        if (messageExchange.getService() != null) {
            reportBean.setProvider(messageExchange.getService().toString());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }
}

