/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.monitoring.service.routing;

import java.util.ArrayList;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.ReceiverModule;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.monitoring.service.time.TimeStamperHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="timestampSender", signature=SenderModule.class), @Interface(name="timestampReceiver", signature=ReceiverModule.class)})
public class TimeStampModule
implements BindingController,
LifeCycleController,
ReceiverModule,
SenderModule {
    protected org.ow2.petals.kernel.api.log.Logger log;
    protected Logger logger;
    private LoggerFactory loggerFactory;

    public Logger getLogger() {
        return this.logger;
    }

    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchange messageExchange) throws RoutingException {
        this.log.call();
        this.setTimeStamp(messageExchange);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean receiveExchange(MessageExchange messageExchange, ComponentContext componentContext) throws RoutingException {
        if (messageExchange != null) {
            this.setTimeStamp(messageExchange);
        }
        return true;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    protected void setTimeStamp(MessageExchange messageExchange) {
        long l = System.currentTimeMillis();
        String string = null;
        if (MessageExchange.Role.CONSUMER.equals(messageExchange.getRole())) {
            if (TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateClientIn() == 0L) {
                TimeStamperHandler.getInstance().getTimeStamp(messageExchange).setDateClientIn(l);
                System.out.println("SETTING T1 for " + messageExchange.getExchangeId());
                string = "t1: ";
            } else if (TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateClientOut() == 0L) {
                TimeStamperHandler.getInstance().getTimeStamp(messageExchange).setDateClientOut(l);
                System.out.println("SETTING T4 for " + messageExchange.getExchangeId());
                string = "t4: ";
            }
        }
        if (MessageExchange.Role.PROVIDER.equals(messageExchange.getRole())) {
            if (TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateProviderIn() == 0L) {
                TimeStamperHandler.getInstance().getTimeStamp(messageExchange).setDateProviderIn(l);
                System.out.println("SETTING T2 for " + messageExchange.getExchangeId());
                string = "t2: ";
            } else if (TimeStamperHandler.getInstance().getTimeStamp(messageExchange).getDateProviderOut() == 0L) {
                TimeStamperHandler.getInstance().getTimeStamp(messageExchange).setDateProviderOut(l);
                System.out.println("SETTING T3 for " + messageExchange.getExchangeId());
                string = "t3: ";
            }
        }
        if (string != null && this.log.isInfoEnabled()) {
            this.log.info((Object)(String.valueOf(string.toUpperCase()) + "timestamp the exchange '" + messageExchange.getExchangeId() + " with date '" + l + "'"));
        }
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

