/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.database;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingEnumerationImpl<T>
implements NamingEnumeration<T> {
    private final List<T> enumeration;
    private boolean closed;

    public NamingEnumerationImpl(List<T> list) {
        this.enumeration = new LinkedList<T>(list);
        this.closed = false;
    }

    @Override
    public void close() throws NamingException {
        this.enumeration.clear();
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMore() throws NamingException {
        if (!this.closed) {
            List<T> list = this.enumeration;
            synchronized (list) {
                return this.enumeration.size() > 0;
            }
        }
        throw new NamingException("This naming enumeration is closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T next() throws NamingException {
        if (!this.closed) {
            T object;
            List<T> list = this.enumeration;
            synchronized (list) {
                if (this.enumeration.size() <= 0) {
                    throw new NoSuchElementException("No more element");
                }
                object = this.enumeration.get(0);
                this.enumeration.remove(0);
            }
            return object;
        }
        throw new NamingException("This naming enumeration is closed.");
    }

    @Override
    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException e) {
            return false;
        }
    }

    @Override
    public T nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            return null;
        }
    }
}

