/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.database;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.CompositeName;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.sql.DataSource;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegistryClient {
    protected static final String ROOT_CONTEXT = "";
    protected static ConcurrentMap<ClientKey, DataSource> DATASOURCES = new ConcurrentHashMap<ClientKey, DataSource>();
    protected final String connectionUrl;
    protected final String username;
    protected final String password;
    protected final int connectionPoolSize;
    protected final int batchSize;
    protected DataSource dataSource;
    protected LoggingUtil log;
    private static final String isContextExistSql = new StringBuffer("SELECT CONTEXT_ID ").append("FROM JNDI_CONTEXT ").append("WHERE CONTEXT = ? FOR UPDATE").toString();
    private static final String createContextSql = new StringBuffer("INSERT INTO JNDI_CONTEXT (CONTEXT) VALUES (?)").toString();
    private static final String destroyContextByIdSql = new StringBuffer("DELETE FROM JNDI_CONTEXT WHERE CONTEXT_ID = ?").toString();
    private static final String isBoundObjectExistWithoutLockSql = new StringBuffer("SELECT JNDI_CONTEXT.CONTEXT_ID, JNDI_BIND.NAME ").append("FROM JNDI_CONTEXT LEFT JOIN JNDI_BIND ").append("ON JNDI_CONTEXT.CONTEXT_ID = JNDI_BIND.CONTEXT_ID ").append("WHERE JNDI_CONTEXT.CONTEXT = ? ").append("AND JNDI_BIND.NAME = ?").toString();
    private static final String createBoundObjectSql = new StringBuffer("INSERT INTO JNDI_BIND ").append("SELECT CONTEXT_ID, ?, ? FROM JNDI_CONTEXT WHERE CONTEXT = ?").toString();
    private static final String getBoundObjectSql = new StringBuffer("SELECT JNDI_BIND.OBJECT ").append("FROM JNDI_CONTEXT INNER JOIN JNDI_BIND ").append("ON JNDI_CONTEXT.CONTEXT_ID = JNDI_BIND.CONTEXT_ID ").append("WHERE JNDI_CONTEXT.CONTEXT = ? ").append("AND JNDI_BIND.NAME = ?").toString();
    private static final String updateBoundObjectSql = new StringBuffer("UPDATE JNDI_BIND ").append("SET OBJECT = ? ").append("WHERE CONTEXT_ID = (SELECT CONTEXT_ID FROM JNDI_CONTEXT WHERE CONTEXT = ?) ").append("AND NAME = ?").toString();
    private static final String destroyBoundObjectSql = new StringBuffer("DELETE FROM JNDI_BIND ").append("WHERE NAME = ? ").append("AND CONTEXT_ID = (SELECT CONTEXT_ID FROM JNDI_CONTEXT WHERE CONTEXT = ? )").toString();

    public RegistryClient(String connectionUrl, String username, String password, int connectionPoolSize, int batchSize, boolean checkTables, LoggingUtil log) throws NamingException {
        this.log = log;
        this.connectionUrl = connectionUrl;
        this.username = username;
        this.password = password;
        this.connectionPoolSize = connectionPoolSize;
        this.batchSize = batchSize;
    }

    public void close() {
        ClientKey key = new ClientKey(this.connectionUrl, this.username, this.password);
        DATASOURCES.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(CompositeName contextName, String objectName, Object object) throws NameAlreadyBoundException, NamingException {
        try {
            String contextNameStr = contextName.toString();
            Connection jdbcConnection = this.dataSource.getConnection();
            try {
                jdbcConnection.setAutoCommit(false);
                if (object == null) {
                    if (this.isContextExist(contextNameStr, jdbcConnection)) {
                        throw new NameAlreadyBoundException(contextNameStr + " already exists.");
                    }
                    this.createContext(contextNameStr, jdbcConnection);
                } else {
                    if (this.isBoundObjectExistWithoutLock(contextNameStr, objectName, jdbcConnection)) {
                        throw new NameAlreadyBoundException(contextNameStr + " already exists.");
                    }
                    this.createBoundObject(contextNameStr, objectName, object, jdbcConnection);
                }
                jdbcConnection.commit();
            }
            finally {
                jdbcConnection.rollback();
                jdbcConnection.close();
            }
        }
        catch (SQLException e) {
            throw new NamingException(e.getMessage());
        }
        catch (IOException e) {
            throw new NamingException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(CompositeName contextName, String objectName, Object object) throws NamingException {
        try {
            String contextNameStr = contextName.toString();
            Connection jdbcConnection = this.dataSource.getConnection();
            try {
                jdbcConnection.setAutoCommit(false);
                if (!this.updateBoundObject(contextNameStr, objectName, object, jdbcConnection)) {
                    this.createBoundObject(contextNameStr, objectName, object, jdbcConnection);
                }
                jdbcConnection.commit();
            }
            finally {
                jdbcConnection.rollback();
                jdbcConnection.close();
            }
        }
        catch (SQLException e) {
            throw new NamingException(e.getMessage());
        }
        catch (IOException e) {
            throw new NamingException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(CompositeName contextName, String objectName) throws NotContextException, NameNotFoundException, ContextNotEmptyException, NamingException {
        try {
            String contextNameStr = contextName.toString();
            Connection jdbcConnection = this.dataSource.getConnection();
            try {
                jdbcConnection.setAutoCommit(false);
                if (objectName == null) {
                    int contextId;
                    block16: {
                        StringBuffer sbCheckContext = new StringBuffer("SELECT JNDI_CONTEXT.CONTEXT_ID, JNDI_BIND.NAME ").append("FROM JNDI_CONTEXT  LEFT JOIN JNDI_BIND ").append("ON JNDI_CONTEXT.CONTEXT_ID = JNDI_BIND.CONTEXT_ID ").append("WHERE JNDI_CONTEXT.CONTEXT = ? ");
                        PreparedStatement pstCheckContext = jdbcConnection.prepareStatement(sbCheckContext.toString());
                        try {
                            pstCheckContext.setString(1, contextNameStr);
                            ResultSet rsCheckContext = pstCheckContext.executeQuery();
                            try {
                                if (rsCheckContext.next()) {
                                    if (rsCheckContext.getString(2) != null) {
                                        throw new ContextNotEmptyException(contextName + " is not empty.");
                                    }
                                    contextId = rsCheckContext.getInt(1);
                                    break block16;
                                }
                                throw new NameNotFoundException(contextName + " does not exist.");
                            }
                            finally {
                                rsCheckContext.close();
                            }
                        }
                        finally {
                            pstCheckContext.close();
                        }
                    }
                    this.destroyContextById(contextId, jdbcConnection);
                } else if (!this.destroyBoundObject(contextNameStr, objectName, jdbcConnection)) {
                    throw new NameNotFoundException(contextName + " does not exist.");
                }
                jdbcConnection.commit();
            }
            finally {
                jdbcConnection.rollback();
                jdbcConnection.close();
            }
        }
        catch (SQLException e) {
            throw new NamingException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(CompositeName contextName, String objectName) throws IsContextException, NameNotFoundException, NamingException {
        Object object;
        String contextNameStr = contextName.toString();
        Connection jdbcConnection = this.dataSource.getConnection();
        try {
            jdbcConnection.setAutoCommit(false);
            Object object2 = this.getBoundObject(contextNameStr, objectName, jdbcConnection);
            if (object2 == null) {
                CompositeName ctx = (CompositeName)contextName.clone();
                ctx.add(objectName);
                String ctxStr = ctx.toString();
                if (this.isContextExist(ctxStr, jdbcConnection)) {
                    throw new IsContextException(ctx);
                }
                throw new NameNotFoundException(ctxStr + " does not exist.");
            }
            jdbcConnection.commit();
            object = object2;
        }
        catch (Throwable throwable) {
            try {
                jdbcConnection.rollback();
                jdbcConnection.close();
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new NamingException(e.getMessage());
            }
            catch (IOException e) {
                throw new NamingException(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new NamingException(e.getMessage());
            }
        }
        jdbcConnection.rollback();
        jdbcConnection.close();
        return object;
    }

    public abstract Map<String, Object> list(CompositeName var1) throws NameNotFoundException, NamingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isContextExist(String contextName, Connection jdbcConnection) throws SQLException {
        PreparedStatement pstCheckContext = jdbcConnection.prepareStatement(isContextExistSql);
        try {
            ResultSet rsCheckContext;
            block8: {
                boolean bl;
                pstCheckContext.setString(1, contextName);
                rsCheckContext = pstCheckContext.executeQuery();
                try {
                    if (!rsCheckContext.next()) break block8;
                    bl = true;
                }
                catch (Throwable throwable) {
                    rsCheckContext.close();
                    throw throwable;
                }
                rsCheckContext.close();
                return bl;
            }
            boolean bl = false;
            rsCheckContext.close();
            return bl;
        }
        finally {
            pstCheckContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createContext(String contextName, Connection jdbcConnection) throws SQLException {
        PreparedStatement pstCreateContext = jdbcConnection.prepareStatement(createContextSql);
        try {
            pstCreateContext.setString(1, contextName);
            pstCreateContext.executeUpdate();
        }
        finally {
            pstCreateContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyContextById(int contextId, Connection jdbcConnection) throws SQLException {
        PreparedStatement pstDestroyContext = jdbcConnection.prepareStatement(destroyContextByIdSql);
        try {
            pstDestroyContext.setInt(1, contextId);
            pstDestroyContext.executeUpdate();
        }
        finally {
            pstDestroyContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBoundObjectExistWithoutLock(String contextName, String objectName, Connection jdbcConnection) throws SQLException {
        PreparedStatement pstCheckContext = jdbcConnection.prepareStatement(isBoundObjectExistWithoutLockSql);
        try {
            ResultSet rsCheckContext;
            block8: {
                boolean bl;
                pstCheckContext.setString(1, contextName);
                pstCheckContext.setString(2, objectName);
                rsCheckContext = pstCheckContext.executeQuery();
                try {
                    if (!rsCheckContext.next()) break block8;
                    bl = true;
                }
                catch (Throwable throwable) {
                    rsCheckContext.close();
                    throw throwable;
                }
                rsCheckContext.close();
                return bl;
            }
            boolean bl = false;
            rsCheckContext.close();
            return bl;
        }
        finally {
            pstCheckContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBoundObject(String contextName, String objectName, Object object, Connection jdbcConnection) throws SQLException, IOException {
        PreparedStatement pstCreateBoundObject = jdbcConnection.prepareStatement(createBoundObjectSql);
        try {
            pstCreateBoundObject.setString(1, objectName);
            RegistryClient.writeObject(pstCreateBoundObject, 2, object);
            pstCreateBoundObject.setString(3, contextName);
            pstCreateBoundObject.executeUpdate();
        }
        finally {
            pstCreateBoundObject.close();
        }
    }

    private static final void writeObject(PreparedStatement pst, int idx, Object object) throws SQLException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        baos.close();
        pst.setBinaryStream(idx, (InputStream)new ByteArrayInputStream(baos.toByteArray()), baos.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBoundObject(String contextName, String objectName, Connection jdbcConnection) throws SQLException, IOException, ClassNotFoundException {
        PreparedStatement pstGetBoundObject = jdbcConnection.prepareStatement(getBoundObjectSql);
        try {
            ResultSet rs;
            block8: {
                Object object;
                pstGetBoundObject.setString(1, contextName);
                pstGetBoundObject.setString(2, objectName);
                rs = pstGetBoundObject.executeQuery();
                try {
                    if (!rs.next()) break block8;
                    object = RegistryClient.readObject(rs, 1);
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return object;
            }
            Object var6_7 = null;
            rs.close();
            return var6_7;
        }
        finally {
            pstGetBoundObject.close();
        }
    }

    protected static final Object readObject(ResultSet rs, int idx) throws SQLException, IOException, ClassNotFoundException {
        InputStream is = rs.getBinaryStream(idx);
        ObjectInputStream ois = new ObjectInputStream(is);
        return ois.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateBoundObject(String contextName, String objectName, Object object, Connection jdbcConnection) throws SQLException, IOException {
        PreparedStatement pstCreateBoundObject = jdbcConnection.prepareStatement(updateBoundObjectSql);
        try {
            RegistryClient.writeObject(pstCreateBoundObject, 1, object);
            pstCreateBoundObject.setString(2, contextName);
            pstCreateBoundObject.setString(3, objectName);
            boolean bl = pstCreateBoundObject.executeUpdate() != 0;
            return bl;
        }
        finally {
            pstCreateBoundObject.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean destroyBoundObject(String contextName, String objectName, Connection jdbcConnection) throws SQLException {
        PreparedStatement pstDestroyBoundObject = jdbcConnection.prepareStatement(destroyBoundObjectSql);
        try {
            pstDestroyBoundObject.setString(1, objectName);
            pstDestroyBoundObject.setString(2, contextName);
            boolean bl = pstDestroyBoundObject.executeUpdate() != 0;
            return bl;
        }
        finally {
            pstDestroyBoundObject.close();
        }
    }

    protected class IsContextException
    extends Exception {
        private static final long serialVersionUID = 4278892374765661555L;
        private final CompositeName contextName;

        public IsContextException(CompositeName contextName) {
            this.contextName = contextName;
        }

        public CompositeName getContextName() {
            return this.contextName;
        }
    }

    protected class ClientKey {
        private final String connectionUrl;
        private final String username;
        private final String password;

        public ClientKey(String connectionUrl, String username, String password) {
            this.connectionUrl = connectionUrl;
            this.username = username;
            this.password = password;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ClientKey key2 = (ClientKey)obj;
            return this.connectionUrl.equals(key2.connectionUrl) && this.username.equals(key2.username) && this.password.equals(key2.password);
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.connectionUrl.hashCode();
            hash = 31 * hash + this.username.hashCode();
            hash = 31 * hash + this.password.hashCode();
            return hash;
        }
    }
}

