/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.database;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.ow2.petals.registry.database.MySqlClient;
import org.ow2.petals.registry.database.NamingEnumerationImpl;
import org.ow2.petals.registry.database.PostgreSqlClient;
import org.ow2.petals.registry.database.RegistryClient;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryContextImpl
implements Context {
    private final String connectionUrl;
    private final String username;
    private final String password;
    private final int connectionPoolSize;
    private final int batchsize;
    private final RegistryClient postgreSqlClient;
    private final CompositeName contextPath;
    private final LoggingUtil log;

    public RegistryContextImpl(String connectionUrl, String username, String password, int connectionPoolSize, int batchsize, LoggingUtil log) throws NamingException {
        this(connectionUrl, username, password, connectionPoolSize, batchsize, new CompositeName(""), true, log);
    }

    public RegistryContextImpl(String connectionUrl, String username, String password, int connectionPoolSize, int batchsize, CompositeName contextPath, boolean checkStructures, LoggingUtil log) throws NamingException {
        this.connectionUrl = connectionUrl;
        this.username = username;
        this.password = password;
        this.connectionPoolSize = connectionPoolSize;
        this.batchsize = batchsize;
        this.contextPath = contextPath;
        this.log = log;
        if (connectionUrl.contains(SGBDNames.mysql.toString())) {
            this.postgreSqlClient = new MySqlClient(connectionUrl, username, password, connectionPoolSize, batchsize, checkStructures, log);
        } else if (connectionUrl.contains(SGBDNames.postgresql.toString())) {
            this.postgreSqlClient = new PostgreSqlClient(connectionUrl, username, password, connectionPoolSize, batchsize, checkStructures, log);
        } else {
            throw new NamingException(" Unsupported SGBD ");
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.log.start((Object)('(' + name + ',' + obj + ')'));
        try {
            this.log.debug((Object)("Class name of the written object: " + obj.getClass().getName()));
            if (obj instanceof Referenceable) {
                obj = ((Referenceable)obj).getReference();
            }
            this.postgreSqlClient.bind(this.contextPath, name, obj);
        }
        finally {
            this.log.end();
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.log.start((Object)('(' + name + ',' + obj + ')'));
        try {
            this.log.debug((Object)("Class name of the written object: " + obj.getClass().getName()));
            if (obj instanceof Referenceable) {
                obj = ((Referenceable)obj).getReference();
            }
            this.postgreSqlClient.rebind(this.contextPath, name, obj);
        }
        finally {
            this.log.end();
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(String name) throws NamingException {
        this.log.start((Object)('(' + name + ')'));
        try {
            Object object;
            if (name == null || name.length() == 0) {
                RegistryContextImpl registryContextImpl = new RegistryContextImpl(this.connectionUrl, this.username, this.password, this.connectionPoolSize, this.batchsize, this.contextPath, false, this.log);
                return registryContextImpl;
            }
            try {
                CompositeName fullName = new CompositeName(name);
                fullName.addAll(0, this.contextPath);
                object = this.postgreSqlClient.lookup((CompositeName)fullName.getPrefix(fullName.size() - 1), fullName.getSuffix(fullName.size() - 1).toString());
            }
            catch (RegistryClient.IsContextException e) {
                object = new RegistryContextImpl(this.connectionUrl, this.username, this.password, this.connectionPoolSize, this.batchsize, e.getContextName(), false, this.log);
            }
            this.log.debug((Object)("Class name of the read object: " + object.getClass().getName()));
            if (object instanceof LinkRef) {
                String linkedName = ((LinkRef)object).getLinkName();
                object = linkedName.startsWith(".") ? this.lookup(linkedName.substring(1)) : new RegistryContextImpl(this.connectionUrl, this.username, this.password, this.connectionPoolSize, this.batchsize, this.log).lookup(linkedName);
            }
            Object object2 = object = RegistryContextImpl.resolveObject(object);
            return object2;
        }
        finally {
            this.log.end();
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String name) throws NamingException {
        this.log.start((Object)('(' + name + ')'));
        try {
            this.postgreSqlClient.unbind(this.contextPath, name);
        }
        finally {
            this.log.end();
        }
    }

    @Override
    public void close() throws NamingException {
        this.postgreSqlClient.close();
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        this.log.start((Object)('(' + name + ')'));
        try {
            Map<String, Object> liste = this.postgreSqlClient.list(RegistryContextImpl.concat(this.contextPath, name));
            this.log.debug((Object)(liste.size() + " objects returned."));
            LinkedList<NameClassPair> enumeration = new LinkedList<NameClassPair>();
            for (Map.Entry<String, Object> entry : liste.entrySet()) {
                Object object = entry.getValue();
                if (object == null) {
                    enumeration.add(new NameClassPair(entry.getKey(), Context.class.getName()));
                    continue;
                }
                enumeration.add(new NameClassPair(entry.getKey(), object.getClass().getName()));
            }
            NamingEnumerationImpl<NameClassPair> namingEnumerationImpl = new NamingEnumerationImpl<NameClassPair>(enumeration);
            return namingEnumerationImpl;
        }
        finally {
            this.log.end();
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        this.log.start((Object)('(' + name + ')'));
        try {
            Map<String, Object> liste = this.postgreSqlClient.list(RegistryContextImpl.concat(this.contextPath, name));
            this.log.debug((Object)(liste.size() + " object(s) returned."));
            LinkedList<Binding> bindings = new LinkedList<Binding>();
            for (Map.Entry<String, Object> entry : liste.entrySet()) {
                Object object = entry.getValue();
                if (object == null) {
                    CompositeName newCtxPath = (CompositeName)RegistryContextImpl.concat(this.contextPath, name).clone();
                    bindings.add(new Binding(entry.getKey(), new RegistryContextImpl(this.connectionUrl, this.username, this.password, this.connectionPoolSize, this.batchsize, newCtxPath, false, this.log)));
                    continue;
                }
                if (object instanceof LinkRef) {
                    String linkedName = ((LinkRef)object).getLinkName();
                    object = linkedName.startsWith(".") ? this.lookup(linkedName.substring(1)) : new RegistryContextImpl(this.connectionUrl, this.username, this.password, this.connectionPoolSize, this.batchsize, this.log).lookup(linkedName);
                }
                bindings.add(new Binding(entry.getKey(), RegistryContextImpl.resolveObject(object)));
            }
            NamingEnumerationImpl<Binding> namingEnumerationImpl = new NamingEnumerationImpl<Binding>(bindings);
            return namingEnumerationImpl;
        }
        finally {
            this.log.end();
        }
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(String name) throws NamingException {
        this.log.start((Object)('(' + name + ')'));
        try {
            CompositeName subPath = RegistryContextImpl.concat(this.contextPath, name);
            this.postgreSqlClient.bind(subPath, null, null);
            RegistryContextImpl registryContextImpl = new RegistryContextImpl(this.connectionUrl, this.username, this.password, this.connectionPoolSize, this.batchsize, subPath, false, this.log);
            return registryContextImpl;
        }
        finally {
            this.log.end();
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.log.start((Object)('(' + name + ')'));
        try {
            CompositeName subPath = RegistryContextImpl.concat(this.contextPath, name);
            this.postgreSqlClient.unbind(subPath, null);
        }
        finally {
            this.log.end();
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.contextPath.toString();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object addToEnvironment(Name propName, Object propVal) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new NamingException("Not yet available");
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new NamingException("Not yet available");
    }

    private static CompositeName concat(CompositeName compositeName, String name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException();
        }
        CompositeName res = (CompositeName)compositeName.clone();
        if (name.length() > 0 && !"/".equals(name)) {
            res.add(name);
        }
        return res;
    }

    public static final Object resolveObject(Object obj) throws NamingException {
        if (obj instanceof Reference) {
            try {
                return NamingManager.getObjectInstance(obj, null, null, null);
            }
            catch (Exception e) {
                throw new NamingException(e.getMessage());
            }
        }
        return obj;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SGBDNames {
        mysql,
        postgresql;

    }
}

