/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.jmx.agent;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.RequiredModelMBean;
import javax.management.monitor.MonitorNotification;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.objectweb.fractal.api.control.SuperController;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.jmx.agent.Admin;
import org.objectweb.fractal.jmx.agent.AdminAttributes;
import org.objectweb.fractal.jmx.agent.AgentContext;
import org.objectweb.fractal.jmx.agent.AgentMonitorMBean;
import org.objectweb.fractal.jmx.agent.Introspector;
import org.objectweb.fractal.util.Fractal;

public class Agent
implements BindingController,
LifeCycleController,
AdminAttributes,
Admin {
    private MBeanServer _server = ManagementFactory.getPlatformMBeanServer();
    private int _depth = -1;
    private String _itfPatterns = "*:*";
    private String _stringMonitors = "";
    private String _counterMonitors = "";
    private String _gaugeMonitors = "";
    private Component _myId = null;
    private NotificationListener _listener = null;
    private AgentContext _ctx = new AgentContext();
    private Registry registry = null;
    private JMXConnectorServer rmiConnectorServer = null;
    private boolean _connectorStarted = false;
    private String _address = "localhost";
    private int _port = 2033;
    private String _adminId = "admin";

    public String[] listFc() {
        return new String[]{"listener"};
    }

    public Object lookupFc(String itfName) {
        if (itfName.equals("listener")) {
            return this._listener;
        }
        return null;
    }

    public void bindFc(String itfName, Object itfValue) {
        if (itfName.equals("component")) {
            this._myId = (Component)itfValue;
        } else if (itfName.equals("listener")) {
            this._listener = (NotificationListener)itfValue;
        }
    }

    public void unbindFc(String itfName) {
        if (itfName.equals("listener")) {
            this._listener = null;
        }
    }

    public String getFcState() {
        return null;
    }

    public void startFc() {
        try {
            ObjectName oName = new ObjectName("Agent:itf=admin");
            this.exposeFcItf(this._myId, oName, "admin");
            oName = new ObjectName("Agent:itf=attribute-controller");
            this.exposeFcItf(this._myId, oName, "attribute-controller");
        }
        catch (JMException e) {
            throw new JMRuntimeException(e.toString());
        }
        try {
            this.startConnector();
        }
        catch (IOException e) {
            throw new JMRuntimeException(e.toString());
        }
    }

    public void stopFc() {
        if (this._connectorStarted && this.rmiConnectorServer != null) {
            try {
                this.rmiConnectorServer.stop();
            }
            catch (IOException e) {
                throw new JMRuntimeException(e.toString());
            }
        }
    }

    public String getItfPatterns() {
        return this._itfPatterns;
    }

    public void setItfPatterns(String str) {
        this._itfPatterns = str == null ? "" : str;
    }

    public String getMonitorStringPatterns() {
        return this._stringMonitors;
    }

    public void setMonitorStringPatterns(String str) {
        this._stringMonitors = str == null ? "" : str;
    }

    public String getMonitorCounterPatterns() {
        return this._counterMonitors;
    }

    public void setMonitorCounterPatterns(String counters) {
        this._counterMonitors = counters == null ? "" : counters;
    }

    public String getMonitorGaugePatterns() {
        return this._gaugeMonitors;
    }

    public void setMonitorGaugePatterns(String gauges) {
        this._gaugeMonitors = gauges == null ? "" : gauges;
    }

    public String getCurrencyTimeLimit() {
        return Introspector.CURRENCY_TIME_LIMIT;
    }

    public void setCurrencyTimeLimit(String currencyTimeLimit) {
        Introspector.CURRENCY_TIME_LIMIT = currencyTimeLimit;
    }

    public MBeanServer getRawMBeanServer() {
        return this._server;
    }

    public void setRawMBeanServer(MBeanServer srv) {
        throw new UnsupportedOperationException();
    }

    public String getAddress() {
        return this._address;
    }

    public boolean getConnectorStarted() {
        return this._connectorStarted;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    public void setConnectorStarted(boolean started) {
        this._connectorStarted = started;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public String getAdminId() {
        return this._adminId;
    }

    public void setAdminId(String adminId) {
        this._adminId = adminId;
    }

    public void expose() throws JMException {
        try {
            this.unregisterMBean("FC*:*");
            this.unregisterMBean("AgentService*:*");
            this._ctx.reset(this._itfPatterns, this._stringMonitors, this._counterMonitors, this._gaugeMonitors);
            Component[] ids = this.exposeSuper(this._myId, new HashSet()).toArray(new Component[0]);
            this.exposeSub(ids, 0);
            this.startMonitors(this._ctx.getMonitors());
        }
        catch (RuntimeException e) {
            throw new JMException(e.toString());
        }
    }

    private Set exposeSuper(Component id, Set set) {
        try {
            SuperController supCtrl = Fractal.getSuperController((Component)id);
            Component[] ids = supCtrl.getFcSuperComponents();
            if (ids.length == 0) {
                set.add(id);
            } else {
                for (int j = 0; j < ids.length; ++j) {
                    try {
                        ids[j].getFcInterface("admin");
                        this.exposeSuper(ids[j], set);
                        continue;
                    }
                    catch (NoSuchInterfaceException e) {
                        set.add(ids[j]);
                    }
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            set.add(id);
        }
        return set;
    }

    private void exposeSub(Component[] ids, int crtDepth) throws JMException {
        if (this._depth >= 0 && crtDepth > this._depth) {
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            try {
                ContentController cCtrl = Fractal.getContentController((Component)ids[i]);
                this.exposeSub(cCtrl.getFcSubComponents(), crtDepth + 1);
            }
            catch (NoSuchInterfaceException ignored) {
                // empty catch block
            }
            String[] names = this.getFullFCName(ids[i]);
            for (int j = 0; j < names.length; ++j) {
                this.exposeFCinfos(ids[i], "/" + names[j] + '@' + Integer.toHexString(ids[i].hashCode()));
            }
        }
    }

    private void exposeFCinfos(Component id, String name) throws JMException {
        InterfaceType[] itfts = ((ComponentType)id.getFcType()).getFcInterfaceTypes();
        String domain = "FC" + name + (this.isShared(id) ? "-shared" : "");
        for (int j = 0; j < itfts.length; ++j) {
            ObjectName oName = new ObjectName(domain + ":itf=" + itfts[j].getFcItfName());
            if (itfts[j].isFcClientItf() || !this._ctx.matchItfPatterns(oName) && !this._ctx.matchMonitorPatterns(oName)) continue;
            this.exposeFcItf(id, oName, itfts[j].getFcItfName());
            boolean ret = this.setObservers(oName, this._ctx.getMonitors());
            if (this._ctx.matchItfPatterns(oName) || ret) continue;
            this._server.unregisterMBean(oName);
        }
    }

    private boolean exposeFcItf(Component cid, ObjectName oname, String itfName) throws JMException {
        boolean ret = false;
        try {
            if (this._server.isRegistered(oname)) {
                return true;
            }
            InterfaceType itfType = ((ComponentType)cid.getFcType()).getFcInterfaceType(itfName);
            String signature = itfType.getFcItfSignature();
            RequiredModelMBean rmBean = Introspector.createMBean(cid.getFcInterface(itfName), Class.forName(signature));
            this._server.registerMBean(rmBean, oname);
            ret = true;
        }
        catch (NoSuchInterfaceException ignored) {
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new IllegalStateException(e.toString());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.toString());
        }
        return ret;
    }

    private boolean setObservers(ObjectName oName, AgentMonitorMBean[] monitors) throws JMException {
        boolean ret = false;
        for (int i = 0; i < monitors.length; ++i) {
            try {
                Class<?> c = this._server.getAttribute(oName, monitors[i].getObservedAttribute()).getClass();
                if (!monitors[i].getPattern().apply(oName) || !monitors[i].getAttributeType().isAssignableFrom(c)) continue;
                monitors[i].addObservedObject(oName);
                ret = true;
                continue;
            }
            catch (AttributeNotFoundException ignored) {
                // empty catch block
            }
        }
        return ret;
    }

    private void startMonitors(AgentMonitorMBean[] monitors) throws JMException {
        if (this._listener == null) {
            return;
        }
        for (int i = 0; i < monitors.length; ++i) {
            ObjectName[] oNames = monitors[i].getObservedObjects();
            if (oNames.length == 0) continue;
            ObjectName monitorName = this._server.registerMBean(monitors[i], null).getObjectName();
            for (int j = 0; j < oNames.length; ++j) {
                this._server.addNotificationListener(monitorName, this._listener, (NotificationFilter)new Filter(oNames[j]), (Object)oNames[j]);
            }
            monitors[i].start();
        }
    }

    private void unregisterMBean(String pattern) throws JMException {
        ObjectName o = new ObjectName(pattern);
        Set<ObjectName> s = this._server.queryNames(o, null);
        Iterator<ObjectName> i = s.iterator();
        while (i.hasNext()) {
            this._server.unregisterMBean(i.next());
        }
    }

    private boolean isShared(Component id) {
        boolean shared = false;
        try {
            Component[] ids = Fractal.getSuperController((Component)id).getFcSuperComponents();
            if (ids.length > 1) {
                shared = true;
            } else if (ids.length > 1) {
                shared = this.isShared(ids[0]);
            }
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        return shared;
    }

    private String[] getFullFCName(Component id) {
        String[] names = null;
        try {
            Component[] ids = Fractal.getSuperController((Component)id).getFcSuperComponents();
            ArrayList<String> l = new ArrayList<String>();
            for (int i = 0; i < ids.length; ++i) {
                String[] tmp = this.getFullFCName(ids[i]);
                int j = 0;
                while (j < tmp.length) {
                    int n = j++;
                    tmp[n] = tmp[n] + "/" + this.getFCName(id);
                }
                l.addAll(Arrays.asList(tmp));
            }
            names = l.toArray(new String[l.size()]);
        }
        catch (NoSuchInterfaceException noSuchInterfaceException) {
            // empty catch block
        }
        if (names == null || names.length == 0) {
            names = new String[]{this.getFCName(id)};
        }
        return names;
    }

    private String getFCName(Component id) {
        try {
            NameController nc = Fractal.getNameController((Component)id);
            return nc.getFcName();
        }
        catch (NoSuchInterfaceException e) {
            throw new IllegalStateException("NameController required");
        }
    }

    private void startConnector() throws IOException, RemoteException {
        JMXServiceURL jmxServiceURL = null;
        String url = "service:jmx:rmi:///jndi/rmi://" + this._address + ":" + this._port + "/fractaljmx_connector";
        if (this._connectorStarted && this.registry == null) {
            try {
                jmxServiceURL = new JMXServiceURL(url);
                this.registry = LocateRegistry.createRegistry(this._port);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        if (this._connectorStarted && this.rmiConnectorServer == null) {
            this.rmiConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxServiceURL, null, this._server);
            this.rmiConnectorServer.start();
            System.out.println("[Agent JMX] connected to " + url);
        }
    }

    class Filter
    implements NotificationFilter {
        ObjectName observedObject;

        Filter(ObjectName observedObject) {
            this.observedObject = observedObject;
        }

        public boolean isNotificationEnabled(Notification n) {
            MonitorNotification notif = (MonitorNotification)n;
            return this.observedObject.equals(notif.getObservedObject());
        }
    }
}

