/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.control.lifecycle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.julia.Util;

public class ChainedIllegalLifeCycleException
extends IllegalLifeCycleException {
    private final Throwable exception;
    private transient Component component;

    public ChainedIllegalLifeCycleException(Throwable exception, Component component, String message) {
        super(message);
        this.exception = exception;
        this.component = component;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Component getComponent() {
        if (this.component != null && !(this.component instanceof Interface)) {
            try {
                return (Component)this.component.getFcInterface("component");
            }
            catch (NoSuchInterfaceException ignored) {
            }
        }
        return this.component;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IllegalLifeCycleException: ");
        buf.append(this.getMessage());
        if (this.getComponent() != null) {
            buf.append(" (component = ");
            Util.toString(this.getComponent(), buf);
            buf.append(')');
        }
        return buf.toString();
    }

    public void printStackTrace() {
        if (this.exception != null) {
            System.err.println((Object)this);
            this.exception.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        if (this.exception != null) {
            s.println((Object)this);
            this.exception.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.exception != null) {
            s.write((Object)((Object)this) + "\n");
            this.exception.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Component c = this.getComponent();
        out.writeObject(c instanceof Interface ? c : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.component = (Component)in.readObject();
    }
}

