/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.ow2.petals.topology.generated.Container;
import org.ow2.petals.topology.generated.Subdomain;
import org.ow2.petals.topology.generated.Topology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopologyHelper {
    private TopologyHelper() {
    }

    public static Subdomain findSubdomain(String subdomainName, Topology topology) {
        Subdomain result = null;
        for (Subdomain subdomain : topology.getDomain().getSubDomain()) {
            if (!subdomain.getName().equals(subdomainName)) continue;
            result = subdomain;
            break;
        }
        return result;
    }

    public static Subdomain findSubdomain(Container container, Topology topology) {
        Subdomain result = null;
        for (Subdomain subdomain : topology.getDomain().getSubDomain()) {
            if (TopologyHelper.findContainer(container.getName(), subdomain) == null) continue;
            result = subdomain;
            break;
        }
        return result;
    }

    public static Container findContainer(String containerName, Topology topology) {
        Subdomain subdomain;
        Container result = null;
        Iterator<Subdomain> i$ = topology.getDomain().getSubDomain().iterator();
        while (i$.hasNext() && (result = TopologyHelper.findContainer(containerName, subdomain = i$.next())) == null) {
        }
        return result;
    }

    public static Container findContainer(String containerName, Subdomain subdomain) {
        Container result = null;
        for (Container container : subdomain.getContainer()) {
            if (!container.getName().equals(containerName)) continue;
            result = container;
            break;
        }
        return result;
    }

    public static Collection<Container> findAllContainers(Topology topology) {
        ArrayList<Container> result = new ArrayList<Container>();
        for (Subdomain subdomain : topology.getDomain().getSubDomain()) {
            for (Container container : subdomain.getContainer()) {
                result.add(container);
            }
        }
        return result;
    }
}

