/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jaxbutils;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.petalslink.dsb.jaxbutils.SOAException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DOMUtil {
    private DocumentBuilderFactory domBuilder = DocumentBuilderFactory.newInstance();
    private static DOMUtil INSTANCE;

    private DOMUtil() {
        this.domBuilder.setNamespaceAware(true);
    }

    public static DOMUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DOMUtil();
        }
        return INSTANCE;
    }

    public Element getFirstElement(Element parent) {
        Element res = null;
        if (parent != null) {
            NodeList list = parent.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeType() != 1) continue;
                res = (Element)list.item(i);
                break;
            }
        }
        return res;
    }

    public Document createDocumentFromElement(Element elmt) throws ParserConfigurationException {
        Document doc = this.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        doc.appendChild((Element)doc.importNode(elmt.cloneNode(true), true));
        return doc;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.domBuilder;
    }

    public Document convertFirstElementIntoDocument(DocumentBuilderFactory factory, Document in) throws SOAException {
        Document res = null;
        try {
            res = factory.newDocumentBuilder().newDocument();
            Element first = this.getFirstElement(in.getDocumentElement());
            if (first != null) {
                res.appendChild(res.importNode(first.cloneNode(true), true));
            }
        }
        catch (ParserConfigurationException e) {
            throw new SOAException(e);
        }
        return res;
    }
}

