/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jaxbutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.SchemaFactory;
import org.petalslink.dsb.jaxbutils.DOMUtil;
import org.petalslink.dsb.jaxbutils.SOAException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAJAXBContext {
    public static String W3C_XML_SCHEMA_INSTANCE_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private JAXBContext jaxbContext;
    protected final List<Class> defaultObjectFactories = new ArrayList<Class>(Arrays.asList(new Class[0]));
    private List<Class> currentObjectFactories = new ArrayList<Class>(this.defaultObjectFactories);
    private static SOAJAXBContext instance = null;

    private SOAJAXBContext() throws SOAException {
        SchemaFactory.newInstance(W3C_XML_SCHEMA_INSTANCE_NS_URI);
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])this.currentObjectFactories.toArray(new Class[this.currentObjectFactories.size()]));
        }
        catch (JAXBException e) {
            throw new SOAException(e);
        }
    }

    public static SOAJAXBContext getInstance() throws SOAException {
        if (instance == null) {
            instance = new SOAJAXBContext();
        }
        return instance;
    }

    public synchronized void addOtherObjectFactory(Class<?> ... list) throws SOAException {
        if (list != null) {
            for (Class<?> clazz : list) {
                if (this.currentObjectFactories.contains(clazz)) continue;
                this.currentObjectFactories.add(clazz);
            }
            try {
                this.jaxbContext = JAXBContext.newInstance((Class[])this.currentObjectFactories.toArray(new Class[this.currentObjectFactories.size()]));
            }
            catch (JAXBException e) {
                throw new SOAException(e);
            }
        }
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public <T> T marshallAnyType(Document doc, Class<T> clazz) throws SOAException {
        Object res = null;
        try {
            Unmarshaller unmarshaller = SOAJAXBContext.getInstance().getJaxbContext().createUnmarshaller();
            JAXBElement binding = unmarshaller.unmarshal((Node)doc, clazz);
            res = binding.getValue();
        }
        catch (JAXBException e) {
            throw new SOAException(e);
        }
        return (T)res;
    }

    public <E> Document unmarshallAnyType(QName tag, E jaxbElmt, Class<E> clazz) throws SOAException {
        Document doc = null;
        try {
            doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            JAXBElement element = new JAXBElement(tag, clazz, jaxbElmt);
            Marshaller marshaller = SOAJAXBContext.getInstance().getJaxbContext().createMarshaller();
            marshaller.marshal((Object)element, (Node)doc);
        }
        catch (JAXBException ex) {
            throw new SOAException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new SOAException(ex);
        }
        return doc;
    }

    public Document unmarshallAnyElement(Object jaxbElmt) throws SOAException {
        Document doc = null;
        try {
            doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            Marshaller marshaller = SOAJAXBContext.getInstance().getJaxbContext().createMarshaller();
            marshaller.marshal(jaxbElmt, (Node)doc);
        }
        catch (JAXBException ex) {
            throw new SOAException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new SOAException(ex);
        }
        return doc;
    }
}

