/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.jaxbutils;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import java.util.HashMap;
import java.util.Map;
import org.petalslink.dsb.jaxbutils.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAUtil {
    private Map<Framework, XmlContext> xmlContexts = new HashMap<Framework, XmlContext>();
    private Map<Framework, ThreadLocal<XmlObjectWriter>> xmlwriters = new HashMap<Framework, ThreadLocal<XmlObjectWriter>>();
    private Map<Framework, ThreadLocal<XmlObjectReader>> xmlreaders = new HashMap<Framework, ThreadLocal<XmlObjectReader>>();
    private static SOAUtil INSTANCE = null;

    private SOAUtil() {
    }

    public static SOAUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SOAUtil();
        }
        return INSTANCE;
    }

    public ThreadLocal<XmlObjectWriter> getWriter(Framework fw) {
        ThreadFrameworkLocal<XmlObjectWriter> xmlwriter = this.xmlwriters.get(fw);
        if (xmlwriter == null) {
            xmlwriter = new ThreadFrameworkLocal<XmlObjectWriter>(fw){

                @Override
                protected XmlObjectWriter initialValue() {
                    return this.getXmlContext().createWriter();
                }
            };
            this.xmlwriters.put(fw, (ThreadLocal<XmlObjectWriter>)xmlwriter);
        }
        return xmlwriter;
    }

    public ThreadLocal<XmlObjectReader> getReader(Framework fw) {
        ThreadFrameworkLocal<XmlObjectReader> xmlreader = this.xmlreaders.get(fw);
        if (xmlreader == null) {
            xmlreader = new ThreadFrameworkLocal<XmlObjectReader>(fw){

                @Override
                protected XmlObjectReader initialValue() {
                    return this.getXmlContext().createReader();
                }
            };
            this.xmlreaders.put(fw, (ThreadLocal<XmlObjectReader>)xmlreader);
        }
        return xmlreader;
    }

    public XmlContext getXmlContext(Framework fw) {
        XmlContext ctxt = this.xmlContexts.get(fw);
        if (ctxt == null) {
            ctxt = new XmlContextFactory().newContext();
            this.xmlContexts.put(fw, ctxt);
        }
        return ctxt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThreadFrameworkLocal<T>
    extends ThreadLocal<T> {
        private Framework fw = null;

        public ThreadFrameworkLocal(Framework fw) {
            this.fw = fw;
        }

        public XmlContext getXmlContext() {
            return SOAUtil.getInstance().getXmlContext(this.fw);
        }
    }
}

