/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.notification.service;

import com.ebmwebsourcing.wsstar.wsnb.services.INotificationConsumer;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.service.WebService;
import org.petalslink.dsb.kernel.api.DSBConfigurationService;
import org.petalslink.dsb.soap.api.Service;
import org.petalslink.dsb.soap.api.ServiceException;
import org.petalslink.dsb.soap.api.SimpleExchange;

@WebService
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=Service.class)})
public class NotificationConsumerService
implements BindingController,
LifeCycleController,
Service {
    private static final String WSDL = "WS-NotificationConsumer.wsdl";
    private static final String NS = "http://docs.oasis-open.org/wsn/bw-2";
    private static final QName INTERFACE = new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer");
    private static final QName ENDPOINT = new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumerPort");
    private static final QName SERVICE = new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumerService");
    private static final String SERVICE_NAME = "NotificationConsumer";
    @Requires(name="configuration", signature=DSBConfigurationService.class)
    private DSBConfigurationService configurationService;
    @Requires(name="notification-consumer", signature=INotificationConsumer.class)
    private INotificationConsumer consumer;
    private LoggerFactory loggerFactory;
    private Logger logger;
    private LoggingUtil log;
    private org.petalslink.dsb.notification.service.NotificationConsumerService delegate;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycleListener
    public void init() {
        this.delegate = new org.petalslink.dsb.notification.service.NotificationConsumerService(INTERFACE, SERVICE, ENDPOINT, WSDL, this.buildURL(), this.consumer);
    }

    private String buildURL() {
        return String.valueOf(this.configurationService.getWSKernelBaseURL()) + SERVICE_NAME;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public String getWSDLURL() {
        return this.getDelegate().getWSDLURL();
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private Service getDelegate() {
        return this.delegate;
    }

    public String getURL() {
        return this.getDelegate().getURL();
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public QName getEndpoint() {
        return this.getDelegate().getEndpoint();
    }

    public QName getInterface() {
        return this.getDelegate().getInterface();
    }

    public QName getService() {
        return this.getDelegate().getService();
    }

    public void invoke(SimpleExchange simpleExchange) throws ServiceException {
        this.getDelegate().invoke(simpleExchange);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!DSBConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBConfigurationService.class.getName());
            }
            this.configurationService = (DSBConfigurationService)object;
            return;
        }
        if (string.equals("notification-consumer")) {
            if (!INotificationConsumer.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + INotificationConsumer.class.getName());
            }
            this.consumer = (INotificationConsumer)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("notification-consumer");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("notification-consumer")) {
            return this.consumer;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("notification-consumer")) {
            this.consumer = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

