/*
 * Decompiled with CFR 0.152.
 */
package spoon.aval.processing;

import java.util.ArrayList;
import java.util.List;
import spoon.processing.AbstractProcessor;
import spoon.processing.Processor;
import spoon.processing.Property;
import spoon.processing.Severity;
import spoon.reflect.Factory;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletenessCheckerProcessor
extends AbstractProcessor<CtAnnotationType<?>> {
    private List<CtPackage> framework;
    private List<CtPackageReference> annotations;
    @Property
    String[] checkPackages;
    @Property
    String[] skipAnnotationsIn;
    @Property
    boolean checkAll = false;

    public void init() {
        super.init();
        this.framework = new ArrayList<CtPackage>();
        this.annotations = new ArrayList<CtPackageReference>();
        this.configurePackages();
    }

    protected void configurePackages() {
        int n;
        int n2;
        String[] stringArray;
        Factory fac = this.getFactory();
        if (this.checkAll) {
            this.framework.addAll(this.getFactory().Package().getAll());
        } else {
            stringArray = this.checkPackages;
            n2 = 0;
            n = stringArray.length;
            while (n2 < n) {
                String check = stringArray[n2];
                this.framework.add(fac.Package().getOrCreate(check));
                ++n2;
            }
        }
        stringArray = this.skipAnnotationsIn;
        n2 = 0;
        n = stringArray.length;
        while (n2 < n) {
            String skip = stringArray[n2];
            this.annotations.add(fac.Package().createReference(skip));
            ++n2;
        }
    }

    public void process(CtAnnotationType<?> element) {
        if (this.shouldSkip(element)) {
            return;
        }
        this.checkTypeUse(element);
        List fields = element.getFields();
        for (CtField field : fields) {
            this.checkAccess(field);
        }
    }

    private boolean shouldSkip(CtAnnotationType<?> element) {
        CtPackageReference elPackRef = element.getPackage().getReference();
        for (CtPackageReference ref : this.annotations) {
            if (!elPackRef.getSimpleName().startsWith(ref.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    private void checkAccess(final CtField<?> field) {
        final boolean[] found = new boolean[]{false};
        for (CtPackage pack : this.framework) {
            new CtScanner(){

                public void scan(CtReference reference) {
                    CtExecutableReference ref;
                    if (reference instanceof CtExecutableReference && (ref = (CtExecutableReference)reference).getSimpleName().equals(field.getSimpleName()) && ref.getDeclaringType().equals(field.getDeclaringType().getReference())) {
                        found[0] = true;
                    }
                    super.scan(reference);
                }
            }.scan((CtElement)pack);
        }
        if (!found[0]) {
            this.getFactory().getEnvironment().report((Processor)this, Severity.WARNING, field, "This Field is never processed!");
        }
    }

    private void checkTypeUse(final CtAnnotationType<?> element) {
        final boolean[] found = new boolean[]{false};
        for (CtPackage pack : this.framework) {
            new CtScanner(){

                public void scan(CtReference reference) {
                    CtTypeReference ref;
                    if (reference instanceof CtTypeReference && (ref = (CtTypeReference)reference).equals(element.getReference())) {
                        found[0] = true;
                    }
                    super.scan(reference);
                }
            }.scan((CtElement)pack);
        }
        if (!found[0]) {
            this.getFactory().getEnvironment().report((Processor)this, Severity.WARNING, element, "This annotation is never processed!");
        }
    }
}

