/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.communication;

import java.util.concurrent.ConcurrentHashMap;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.petalslink.dsb.kernel.communication.RemoteCheckerClient;

public class WebServiceClientFactory {
    static WebServiceClientFactory INSTANCE;
    final ConcurrentHashMap<String, RemoteCheckerClient> clients = new ConcurrentHashMap();

    public static final synchronized WebServiceClientFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebServiceClientFactory();
        }
        return INSTANCE;
    }

    private WebServiceClientFactory() {
    }

    public synchronized RemoteCheckerClient get(String string) throws PetalsException {
        RemoteCheckerClient remoteCheckerClient = this.clients.get(string);
        if (remoteCheckerClient == null) {
            remoteCheckerClient = new RemoteCheckerClient(string);
            try {
                remoteCheckerClient.init();
                this.clients.put(string, remoteCheckerClient);
            }
            catch (RuntimeException runtimeException) {
                throw new PetalsException("Can not instanctiate web service client", runtimeException);
            }
        }
        return remoteCheckerClient;
    }
}

