/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.communication;

import java.util.ArrayList;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.communication.RemoteCheckerClient;
import org.petalslink.dsb.kernel.communication.WebServiceClientFactory;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=org.ow2.petals.communication.RemoteCheckerClient.class)})
public class WebServiceRemoteCheckerClientImpl
implements BindingController,
LifeCycleController,
org.ow2.petals.communication.RemoteCheckerClient {
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="topology", signature=TopologyService.class)
    private TopologyService topologyService;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug("Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug("Stopping...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean ping(String string) {
        boolean bl = true;
        ContainerConfiguration containerConfiguration = null;
        try {
            containerConfiguration = this.topologyService.getContainerConfiguration(string);
            if (containerConfiguration == null) {
                bl = false;
            } else {
                RemoteCheckerClient remoteCheckerClient;
                String string2 = this.getWebServiceAddress(containerConfiguration);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Pinging remote container on " + string2);
                }
                if ((remoteCheckerClient = WebServiceClientFactory.getInstance().get(string2)) != null) {
                    bl = remoteCheckerClient.ping();
                } else {
                    this.log.warning("Can not create the client to ping the remote container");
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            this.log.warning(exception.getMessage());
            bl = false;
        }
        return bl;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private String getWebServiceAddress(ContainerConfiguration containerConfiguration) {
        return "http://" + containerConfiguration.getHost() + ":" + containerConfiguration.getWebservicePort() + "/" + containerConfiguration.getWebservicePrefix() + "/" + "RemoteCheckerService";
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("topology");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("topology")) {
            return this.topologyService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

