/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.cxf;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.ow2.petals.registry.api.util.XMLUtil;
import org.petalslink.dsb.service.client.MessageImpl;
import org.petalslink.dsb.service.client.MessageListener;
import org.petalslink.dsb.xmlutils.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DSBDestinationOutputStream
extends CachedOutputStream {
    private static final Logger LOG = LogUtils.getL7dLogger(DSBDestinationOutputStream.class);
    private Message inMessage;
    private Message outMessage;
    private MessageListener responseListener;

    public DSBDestinationOutputStream(Message message, Message message2, MessageListener messageListener) {
        this.inMessage = message;
        this.outMessage = message2;
        this.responseListener = messageListener;
    }

    protected void doFlush() throws IOException {
    }

    protected void doClose() throws IOException {
        this.commitOutputMessage();
    }

    protected void onWrite() throws IOException {
    }

    private void commitOutputMessage() throws IOException {
        try {
            if (this.inMessage.getExchange().isOneWay()) {
                return;
            }
            InputStream inputStream = this.getInputStream();
            Document document = XMLHelper.createDocument((Source)new StreamSource(inputStream), (boolean)true);
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("On destination to be sent back to the client" + XMLUtil.createStringFromDOMDocument((Node)document));
            }
            inputStream.close();
            MessageImpl messageImpl = new MessageImpl();
            if (this.inMessage.get((Object)"DSB-CORRELATION") != null) {
                messageImpl.getProperties().put("DSB-CORRELATION", this.inMessage.get((Object)"DSB-CORRELATION").toString());
            }
            this.responseListener.onMessage((org.petalslink.dsb.service.client.Message)messageImpl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

