/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.cxf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.jbi.JBIException;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.petalslink.dsb.kernel.cxf.DSBConduit;
import org.petalslink.dsb.kernel.cxf.DSBDestination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSBTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory {
    public static final String TRANSPORT_ID = "http://cxf.apache.org/transports/dsb";
    public static final List<String> DEFAULT_NAMESPACES = Arrays.asList("http://cxf.apache.org/transports/dsb", "http://cxf.apache.org/transports/dsb/configuration");
    private Bus bus;
    private final Map<String, DSBDestination> destinationMap = new HashMap<String, DSBDestination>();
    private Collection<String> activationNamespaces = DEFAULT_NAMESPACES;

    public DSBTransportFactory() {
        this.setTransportIds(Arrays.asList(TRANSPORT_ID));
    }

    @Resource(name="cxf")
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Bus getBus() {
        return this.bus;
    }

    public Set<String> getUriPrefixes() {
        return Collections.singleton("dsb");
    }

    public void setActivationNamespaces(Collection<String> collection) {
        this.activationNamespaces = collection;
    }

    @PostConstruct
    public void registerWithBindingManager() {
        DestinationFactoryManager destinationFactoryManager;
        if (this.bus == null) {
            return;
        }
        ConduitInitiatorManager conduitInitiatorManager = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        if (conduitInitiatorManager != null && this.activationNamespaces != null) {
            for (String string : this.activationNamespaces) {
                conduitInitiatorManager.registerConduitInitiator(string, (ConduitInitiator)this);
            }
        }
        if ((destinationFactoryManager = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)) != null && this.activationNamespaces != null) {
            for (String string : this.activationNamespaces) {
                destinationFactoryManager.registerDestinationFactory(string, (DestinationFactory)this);
            }
        }
    }

    public Conduit getConduit(EndpointInfo endpointInfo) throws IOException {
        return this.getConduit(endpointInfo, null);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType endpointReferenceType) throws IOException {
        DSBConduit dSBConduit = new DSBConduit(endpointReferenceType);
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (configurer != null) {
            configurer.configureBean((Object)dSBConduit);
        }
        return dSBConduit;
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        DSBDestination dSBDestination = new DSBDestination(endpointInfo);
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (configurer != null) {
            configurer.configureBean((Object)dSBDestination);
        }
        try {
            this.putDestination(String.valueOf(endpointInfo.getService().getName().toString()) + endpointInfo.getInterface().getName().toString(), dSBDestination);
        }
        catch (JBIException jBIException) {
            throw new IOException(jBIException.getMessage());
        }
        return dSBDestination;
    }

    public void putDestination(String string, DSBDestination dSBDestination) throws JBIException {
        if (this.destinationMap.containsKey(string)) {
            throw new JBIException("DSBDestination for Endpoint " + string + " has already been created");
        }
        this.destinationMap.put(string, dSBDestination);
    }

    public DSBDestination getDestination(String string) {
        return this.destinationMap.get(string);
    }

    public void removeDestination(String string) {
        this.destinationMap.remove(string);
    }
}

