/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.information;

import java.util.ArrayList;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.tools.ws.WebServiceManager;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.api.DSBConfigurationService;
import org.petalslink.dsb.kernel.information.HttpServer;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=HttpServer.class)})
public class JettyHttpServerImpl
implements BindingController,
LifeCycleController,
HttpServer {
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="configuration", signature=DSBConfigurationService.class)
    private DSBConfigurationService configurationService;
    @Requires(name="wsmanager", signature=WebServiceManager.class)
    private WebServiceManager webServiceManager;
    private Server server;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug("Starting...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug("Stopping...");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void startServer() {
        System.out.println("######### STARTING ON = " + this.configurationService.getWebAppPort());
        this.server = new Server(this.configurationService.getWebAppPort());
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        this.server.setHandler((Handler)contextHandlerCollection);
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopServer() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                this.log.warning(exception.getMessage());
            }
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!DSBConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBConfigurationService.class.getName());
            }
            this.configurationService = (DSBConfigurationService)object;
            return;
        }
        if (string.equals("wsmanager")) {
            if (!WebServiceManager.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + WebServiceManager.class.getName());
            }
            this.webServiceManager = (WebServiceManager)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("wsmanager");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("wsmanager")) {
            return this.webServiceManager;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("wsmanager")) {
            this.webServiceManager = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

