/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.io.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.ComponentContextCommunication;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.component.context.ComponentContextImpl;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.messaging.endpoint.EndpointPropertiesService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.kernel.api.service.Location;
import org.ow2.petals.kernel.api.service.ServiceEndpoint;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.service.ServiceEndpointImpl;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.jbi.JBISender;
import org.petalslink.dsb.kernel.io.client.ClientFactoryRegistry;
import org.petalslink.dsb.service.client.Client;
import org.petalslink.dsb.service.client.ClientException;
import org.petalslink.dsb.service.client.ClientFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ClientFactory.class)})
public class DSBClientFactoryImpl
implements BindingController,
LifeCycleController,
ClientFactory {
    private LoggerFactory loggerFactory;
    private Logger logger;
    private LoggingUtil log;
    private AtomicLong counter = new AtomicLong(0L);
    private static final String COMPONENT_NAME_PREFIX = "internalclient-";
    private Map<String, JBISender> cache;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="router", signature=RouterService.class)
    private RouterService router;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @LifeCycle(on=LifeCycleType.START)
    public void start() {
        this.log = new LoggingUtil(this.logger);
        this.cache = new HashMap<String, JBISender>();
        ClientFactoryRegistry.setFactory(this);
        this.log.start();
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() {
        this.log.end();
        this.cache = null;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public Client getClient(org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint) throws ClientException {
        Client client;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Getting a client for service " + serviceEndpoint);
        }
        if ((client = this.getOldClient(serviceEndpoint)) != null) {
            return client;
        }
        return this.createClient(serviceEndpoint);
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected Client createClient(org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint) throws ClientException {
        String string = this.getClientId(serviceEndpoint);
        final ServiceEndpointImpl serviceEndpointImpl = new ServiceEndpointImpl();
        serviceEndpointImpl.setType(ServiceEndpoint.EndpointType.INTERNAL);
        org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint2 = this.getServiceEndpointClient(serviceEndpoint);
        if (serviceEndpoint2.getEndpointName() != null) {
            serviceEndpointImpl.setEndpointName(serviceEndpoint2.getEndpointName());
        }
        if (serviceEndpoint2.getInterfaces() != null) {
            serviceEndpointImpl.setInterfacesName(Arrays.asList(serviceEndpoint2.getInterfaces()));
        }
        if (serviceEndpoint2.getServiceName() != null) {
            serviceEndpointImpl.setServiceName(serviceEndpoint2.getServiceName());
        }
        serviceEndpointImpl.setLocation(this.getLocation(string));
        ComponentContextCommunication componentContextCommunication = new ComponentContextCommunication(){

            public String getWorkspaceRoot() {
                return null;
            }

            public TransactionManager getTransactionManagerService() {
                return null;
            }

            public RouterService getRouterService() {
                return DSBClientFactoryImpl.this.router;
            }

            public Logger getLogger() {
                return DSBClientFactoryImpl.this.logger;
            }

            public Jbi getJBIDescriptor() {
                return null;
            }

            public String getInstallationRoot() {
                return null;
            }

            public InitialContext getInitialContext() {
                return null;
            }

            public EndpointRegistry getEndpointRegistry() {
                return null;
            }

            public EndpointPropertiesService getEndpointPropertiesService() {
                return null;
            }

            public AdminService getAdminService() {
                return null;
            }

            public ServiceEndpoint getAddress() {
                return new ServiceEndpoint(this, serviceEndpointImpl){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ ServiceEndpointImpl val$clientServiceEndpoint;
                    {
                        this.this$1 = var1_1;
                        this.val$clientServiceEndpoint = serviceEndpointImpl;
                    }

                    public DocumentFragment getAsReference(QName qName) {
                        return null;
                    }

                    public String getEndpointName() {
                        return this.val$clientServiceEndpoint.getEndpointName();
                    }

                    public QName[] getInterfaces() {
                        return this.val$clientServiceEndpoint.getInterfacesName().toArray(new QName[this.val$clientServiceEndpoint.getInterfacesName().size()]);
                    }

                    public QName getServiceName() {
                        return this.val$clientServiceEndpoint.getServiceName();
                    }

                    public ServiceEndpoint.EndpointType getType() {
                        return this.val$clientServiceEndpoint.getType();
                    }

                    public void setType(ServiceEndpoint.EndpointType endpointType) {
                    }

                    public List<QName> getInterfacesName() {
                        return this.val$clientServiceEndpoint.getInterfacesName();
                    }

                    public Document getDescription() {
                        return null;
                    }

                    public Location getLocation() {
                        return this.val$clientServiceEndpoint.getLocation();
                    }

                    public String toString() {
                        return "CLIENT EP : " + this.getEndpointName() + " @ " + this.getLocation();
                    }
                };
            }
        };
        FakeComponentContext fakeComponentContext = new FakeComponentContext(componentContextCommunication, string);
        JBISender jBISender = new JBISender((ComponentContext)fakeComponentContext, serviceEndpoint);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initializing DSB kernel with the newly created client...");
        }
        try {
            this.router.addComponent(fakeComponentContext);
        }
        catch (RoutingException routingException) {
            throw new ClientException("Can not create client", (Throwable)((Object)routingException));
        }
        this.cache.put(string, jBISender);
        return jBISender;
    }

    private Client getOldClient(org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint) {
        String string = this.getClientId(serviceEndpoint);
        return (Client)this.cache.get(string);
    }

    private String getClientId(org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint) {
        StringBuffer stringBuffer = new StringBuffer(COMPONENT_NAME_PREFIX);
        if (serviceEndpoint != null) {
            if (serviceEndpoint.getEndpointName() != null) {
                stringBuffer.append("ep=");
                stringBuffer.append(serviceEndpoint.getEndpointName());
                stringBuffer.append(";");
            }
            if (serviceEndpoint.getServiceName() != null) {
                stringBuffer.append("srv=");
                stringBuffer.append(serviceEndpoint.getServiceName().toString());
                stringBuffer.append(";");
            }
            if (serviceEndpoint.getInterfaces() != null && serviceEndpoint.getInterfaces().length > 0) {
                stringBuffer.append("itf=");
                stringBuffer.append(serviceEndpoint.getInterfaces()[0].toString());
                stringBuffer.append(";");
            }
        }
        return stringBuffer.toString();
    }

    private Location getLocation(String string) {
        return new Location(this.configurationService.getContainerConfiguration().getSubdomainName(), this.configurationService.getContainerConfiguration().getName(), string);
    }

    public void release(Client client) throws ClientException {
        if (client == null) {
            return;
        }
        try {
            JBISender jBISender = this.cache.get(client.getName());
            if (jBISender != null) {
                this.router.removeComponent(jBISender.getComponentContext());
            }
        }
        catch (RoutingException routingException) {
            throw new ClientException((Throwable)((Object)routingException));
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("router")) {
            if (!RouterService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterService.class.getName());
            }
            this.router = (RouterService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private org.petalslink.dsb.api.ServiceEndpoint getServiceEndpointClient(org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint) {
        org.petalslink.dsb.api.ServiceEndpoint serviceEndpoint2 = new org.petalslink.dsb.api.ServiceEndpoint();
        long l = this.counter.incrementAndGet();
        if (serviceEndpoint.getEndpointName() != null) {
            serviceEndpoint2.setEndpointName(String.valueOf(serviceEndpoint.getEndpointName()) + "-" + l);
        }
        if (serviceEndpoint.getServiceName() != null) {
            QName qName = new QName(serviceEndpoint.getServiceName().getNamespaceURI(), String.valueOf(serviceEndpoint.getServiceName().getLocalPart()) + "-" + l);
            serviceEndpoint2.setServiceName(qName);
        }
        return serviceEndpoint2;
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("router");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("router")) {
            return this.router;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("router")) {
            this.router = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    class FakeComponentContext
    extends ComponentContextImpl {
        String componentName;

        public FakeComponentContext(ComponentContextCommunication componentContextCommunication, String string) {
            super(componentContextCommunication);
            this.componentName = string;
        }

        public String getComponentName() {
            return this.componentName;
        }
    }
}

