/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.io.server;

import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.petalslink.dsb.jbi.Adapter;
import org.petalslink.dsb.kernel.io.server.DSBServiceServer;
import org.petalslink.dsb.service.client.Message;
import org.petalslink.dsb.service.client.MessageListener;

public class DSBServiceServerImpl
implements DSBServiceServer {
    private MessageListener listener;
    private ComponentContext componentContext;
    private boolean running;
    int activeEndpoints;
    private Logger logger;
    private DeliveryChannel channel;

    public DSBServiceServerImpl(ComponentContext componentContext) {
        this.componentContext = componentContext;
        try {
            this.channel = this.componentContext.getDeliveryChannel();
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
        }
        try {
            this.logger = this.componentContext.getLogger("", null);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
        catch (JBIException jBIException) {
            jBIException.printStackTrace();
        }
    }

    public void start() {
        ++this.activeEndpoints;
        if (!this.running && this.channel != null) {
            new Thread(new ChannelListenner()).start();
        }
    }

    public void stop() {
        --this.activeEndpoints;
    }

    public void setListener(MessageListener messageListener) {
        if (messageListener == null) {
            return;
        }
        this.listener = messageListener;
    }

    public MessageListener getListener() {
        return this.listener;
    }

    public void dispatch(MessageExchange messageExchange) {
        if (this.getListener() == null) {
            return;
        }
        if (messageExchange != null && messageExchange.getMessage("in") != null) {
            Message message = Adapter.transform((NormalizedMessage)messageExchange.getMessage("in"));
            Message message2 = this.getListener().onMessage(message);
            if (message2 != null) {
                try {
                    messageExchange.setMessage(Adapter.transform((Message)message2), "out");
                }
                catch (MessagingException messagingException) {
                    messagingException.printStackTrace();
                }
            }
        }
    }

    private class ChannelListenner
    implements Runnable {
        private ChannelListenner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                DeliveryChannel deliveryChannel = DSBServiceServerImpl.this.channel;
                synchronized (deliveryChannel) {
                    DSBServiceServerImpl.this.running = true;
                }
                do {
                    deliveryChannel = null;
                    DeliveryChannel deliveryChannel2 = DSBServiceServerImpl.this.channel;
                    synchronized (deliveryChannel2) {
                        try {
                            DSBServiceServerImpl.this.logger.fine("Waiting for a message on kernel service server");
                            deliveryChannel = DSBServiceServerImpl.this.channel.accept();
                        }
                        catch (Exception exception) {}
                    }
                    DSBServiceServerImpl.this.logger.fine("Got a message on the listener");
                    if (deliveryChannel != null && deliveryChannel.getStatus() == ExchangeStatus.ACTIVE) {
                        DSBServiceServerImpl.this.logger.fine("Dispatch message...");
                        DSBServiceServerImpl.this.dispatch((MessageExchange)deliveryChannel);
                        DSBServiceServerImpl.this.logger.fine("Send back the message");
                        if (deliveryChannel.getMessage("out") == null) continue;
                        DSBServiceServerImpl.this.channel.send((MessageExchange)deliveryChannel);
                        continue;
                    }
                    DSBServiceServerImpl.this.logger.fine("Do not care about this message status : " + deliveryChannel.getStatus());
                } while (DSBServiceServerImpl.this.activeEndpoints > 0);
                deliveryChannel = DSBServiceServerImpl.this.channel;
                synchronized (deliveryChannel) {
                    DSBServiceServerImpl.this.running = false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

