/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.binder;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.descriptor.original.generated.Jbi;
import org.ow2.petals.jbi.management.deployment.AtomicDeploymentService;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.tools.generator.jbi.api.JBIGenerationException;
import org.ow2.petals.tools.generator.jbi.ws2jbi.Constants;
import org.ow2.petals.tools.generator.rest2jbi.REST2Jbi;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.jbi.JBIFileHelper;
import org.petalslink.dsb.kernel.api.management.binder.BinderChecker;
import org.petalslink.dsb.kernel.api.management.binder.BinderException;
import org.petalslink.dsb.kernel.api.management.binder.ServiceBinder;
import org.petalslink.dsb.kernel.api.management.binder.ServiceRegistry;
import org.petalslink.dsb.ws.api.ServiceEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ServiceBinder.class)})
public class RESTServiceBinderImpl
implements BindingController,
LifeCycleController,
ServiceBinder {
    private LoggerFactory loggerFactory;
    public static final String WORK_DIR = "servicebinder";
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="atomic-deployment", signature=AtomicDeploymentService.class)
    private AtomicDeploymentService deploymentService;
    @Requires(name="service-registry", signature=ServiceRegistry.class)
    private ServiceRegistry serviceRegistry;
    @Requires(name="binder-checker", signature=BinderChecker.class)
    private BinderChecker binderChecker;
    private File workPath;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug("Starting...");
        this.workPath = new File(this.configurationService.getContainerConfiguration().getWorkDirectoryPath(), WORK_DIR);
        if (!this.workPath.exists()) {
            this.workPath.mkdirs();
        }
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug("Stopping...");
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public List<ServiceEndpoint> bind(Map<String, Object> map) throws BinderException {
        Jbi jbi;
        File file;
        String string;
        ArrayList<ServiceEndpoint> arrayList;
        block17: {
            boolean bl;
            String string2;
            block16: {
                URI uRI;
                String string3;
                arrayList = null;
                if (!this.binderChecker.canBindOnProtocol(this.getProtocol())) {
                    throw new BinderException("No component found to bind REST service");
                }
                string = map.get("restURL") != null ? map.get("restURL").toString() : null;
                String string4 = string3 = map.get("ep") != null ? map.get("ep").toString() : null;
                if (string == null) {
                    throw new BinderException("REST URL can not be null");
                }
                file = null;
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new BinderException("Bad REST URL " + uRISyntaxException.getMessage());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(Constants.OUTPUT_DIR, this.workPath.getAbsolutePath());
                hashMap.put("component.version", "1.0");
                hashMap.put("endpoint", string3);
                hashMap.put("rest.endpointprefix", "RestPlatform");
                REST2Jbi rEST2Jbi = new REST2Jbi(uRI, string3, hashMap);
                try {
                    file = rEST2Jbi.generate();
                }
                catch (JBIGenerationException jBIGenerationException) {
                    throw new BinderException(jBIGenerationException.getMessage());
                }
                jbi = JBIFileHelper.readDescriptor((File)file);
                if (jbi == null) {
                    throw new BinderException("Can not get the JBI descriptor...");
                }
                string2 = jbi.getServiceAssembly().getIdentification().getName();
                if (string2 == null) {
                    throw new BinderException("Can not get the JBI service assembly name");
                }
                bl = false;
                try {
                    bl = this.deploymentService.deploy(file.toURL());
                    if (bl) {
                        this.log.info("Service assembly '" + string2 + "' has been deployed");
                        break block16;
                    }
                    this.log.warning("Failed to deploy the Service Assembly located at '" + file.toURL());
                    throw new PEtALSWebServiceException("Deployment failure");
                }
                catch (Exception exception) {
                    throw new BinderException((Throwable)exception);
                }
            }
            try {
                bl = this.deploymentService.start(string2);
                if (bl) {
                    this.log.info("Service assembly '" + string2 + "' has been deployed");
                    break block17;
                }
                this.log.warning("Failed to start the Service Assembly '" + string2 + "'");
                throw new PEtALSWebServiceException("Start failure");
            }
            catch (Exception exception) {
                throw new BinderException((Throwable)exception);
            }
        }
        this.serviceRegistry.addService("rest", string, null);
        if (file != null) {
            file.delete();
        }
        arrayList = new ArrayList<ServiceEndpoint>();
        List list = jbi.getServices().getProvides();
        for (org.ow2.petals.jbi.descriptor.original.generated.Provides provides : list) {
            ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
            serviceEndpoint.setEndpoint(provides.getEndpointName());
            serviceEndpoint.setItf(provides.getInterfaceName());
            serviceEndpoint.setService(provides.getServiceName());
            arrayList.add(serviceEndpoint);
        }
        return arrayList;
    }

    public String getProtocol() {
        return "rest";
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("atomic-deployment")) {
            if (!AtomicDeploymentService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AtomicDeploymentService.class.getName());
            }
            this.deploymentService = (AtomicDeploymentService)object;
            return;
        }
        if (string.equals("service-registry")) {
            if (!ServiceRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ServiceRegistry.class.getName());
            }
            this.serviceRegistry = (ServiceRegistry)object;
            return;
        }
        if (string.equals("binder-checker")) {
            if (!BinderChecker.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + BinderChecker.class.getName());
            }
            this.binderChecker = (BinderChecker)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("atomic-deployment");
        arrayList.add("service-registry");
        arrayList.add("binder-checker");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("atomic-deployment")) {
            return this.deploymentService;
        }
        if (string.equals("service-registry")) {
            return this.serviceRegistry;
        }
        if (string.equals("binder-checker")) {
            return this.binderChecker;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("atomic-deployment")) {
            this.deploymentService = null;
            return;
        }
        if (string.equals("service-registry")) {
            this.serviceRegistry = null;
            return;
        }
        if (string.equals("binder-checker")) {
            this.binderChecker = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

