/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.component;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.management.installation.ComponentInstallationService;
import org.ow2.petals.system.repository.artifact.Artifact;
import org.ow2.petals.system.repository.artifact.ArtifactRepositoryService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.kernel.api.DSBConfigurationService;
import org.petalslink.dsb.kernel.api.management.component.EmbeddedComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=EmbeddedComponentService.class)})
public class EmbeddedComponentServiceImpl
implements BindingController,
LifeCycleController,
EmbeddedComponentService {
    private Logger logger;
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    @Requires(name="dsb-configuration", signature=DSBConfigurationService.class)
    private DSBConfigurationService configurationService;
    @Requires(name="installation", signature=ComponentInstallationService.class)
    private ComponentInstallationService componentInstallationService;
    @Requires(name="artifact-repository", signature=ArtifactRepositoryService.class)
    private ArtifactRepositoryService artifactRepositoryService;
    @Requires(name="adminService", signature=AdminService.class)
    private AdminService adminService;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug("Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug("Stopping...");
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    @LifeCycleListener(phase=Phase.START, priority=1000)
    public void install() {
        this.log.info("It is time to install embedded components...");
        StringBuffer stringBuffer = new StringBuffer("Installation result : ");
        for (String string : this.getComponents()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Installing component '" + string + "'");
            }
            if (string != null && string.trim().length() > 0 && this.getComponentURL(string) != null) {
                if (this.adminService.getComponentByName(string) == null) {
                    boolean bl = this.componentInstallationService.install(this.getComponentURL(string));
                    if (bl) {
                        this.log.debug("Component '" + string + "' has been successfully installed!");
                    } else {
                        this.log.warning("Component '" + string + "' has not been installed!");
                    }
                    stringBuffer.append(" Component = " + string);
                    stringBuffer.append(", installation success : ");
                    stringBuffer.append(bl);
                    continue;
                }
                this.log.info("The component '" + string + "' is already installed");
                continue;
            }
            this.log.warning("Bad component name '" + string + "' or component not found in components repository");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(stringBuffer.toString());
        }
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public List<String> getComponents() {
        return this.configurationService.getEmbeddedComponentList();
    }

    private URL getComponentURL(String string) {
        URL uRL = null;
        List<Artifact> list = this.artifactRepositoryService.getComponents();
        boolean bl = false;
        Iterator<Artifact> iterator = list.iterator();
        Artifact artifact = null;
        while (iterator.hasNext() && !bl) {
            artifact = iterator.next();
            bl = string.equals(artifact.getName());
        }
        if (artifact != null) {
            try {
                uRL = artifact.getFile().toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("URL of component " + string + " is " + uRL);
        }
        return uRL;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("dsb-configuration")) {
            if (!DSBConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + DSBConfigurationService.class.getName());
            }
            this.configurationService = (DSBConfigurationService)object;
            return;
        }
        if (string.equals("installation")) {
            if (!ComponentInstallationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ComponentInstallationService.class.getName());
            }
            this.componentInstallationService = (ComponentInstallationService)object;
            return;
        }
        if (string.equals("artifact-repository")) {
            if (!ArtifactRepositoryService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ArtifactRepositoryService.class.getName());
            }
            this.artifactRepositoryService = (ArtifactRepositoryService)object;
            return;
        }
        if (string.equals("adminService")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("dsb-configuration");
        arrayList.add("installation");
        arrayList.add("artifact-repository");
        arrayList.add("adminService");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("dsb-configuration")) {
            return this.configurationService;
        }
        if (string.equals("installation")) {
            return this.componentInstallationService;
        }
        if (string.equals("artifact-repository")) {
            return this.artifactRepositoryService;
        }
        if (string.equals("adminService")) {
            return this.adminService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("dsb-configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("installation")) {
            this.componentInstallationService = null;
            return;
        }
        if (string.equals("artifact-repository")) {
            this.artifactRepositoryService = null;
            return;
        }
        if (string.equals("adminService")) {
            this.adminService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

