/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.management.component;

import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIUtil {
    private static Log logger = LogFactory.getLog(JNDIUtil.class);

    private JNDIUtil() {
    }

    public static <T> T getObject(Class<T> clazz, Context context, String string, String string2) {
        Object var4_4 = null;
        Context context2 = JNDIUtil.getContext(context, string);
        if (context2 == null) {
            logger.warn((Object)("Can not find a valid context under " + string));
        }
        Object object = null;
        try {
            object = context2.lookup(string2);
        }
        catch (NamingException namingException) {
            logger.warn((Object)namingException.getMessage());
        }
        if (object == null) {
            logger.debug((Object)("Null object under property '" + string2 + "' path"));
            var4_4 = null;
        } else {
            try {
                var4_4 = clazz.cast(object);
            }
            catch (ClassCastException classCastException) {
                logger.warn((Object)("Can not cast the object of class " + object.getClass().getCanonicalName() + " to " + clazz.getCanonicalName()));
            }
        }
        return var4_4;
    }

    public static final Context getContext(Context context, String string) {
        Context context2 = null;
        String string2 = string;
        if (string2 != null && string2.length() >= 1 && string2.indexOf(47) == 0) {
            string2 = string2.substring(1, string2.length());
        }
        if (string2.lastIndexOf(47) == string2.length()) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String[] stringArray = string2.split("/");
        Context context3 = null;
        boolean bl = false;
        int n = 0;
        while (!bl && n < stringArray.length) {
            Object object = null;
            String string3 = stringArray[n++];
            logger.debug((Object)("Looking to context for path = " + string3));
            try {
                object = context3.lookup(string3);
            }
            catch (NamingException namingException) {
                logger.warn((Object)namingException);
            }
            if (object == null) {
                logger.debug((Object)("Nothing found for path = " + string3));
                bl = true;
                continue;
            }
            if (object instanceof Context) {
                logger.debug((Object)("Found something which is a Context for path = " + string3));
                context3 = (Context)object;
                if (n != stringArray.length) continue;
                logger.debug((Object)("Last entry, this is the context we return for path = " + string3));
                context2 = context3;
                bl = true;
                continue;
            }
            logger.debug((Object)("Found something which is not a Context for path = " + string3));
            bl = true;
        }
        return context2;
    }
}

