/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.messaging.router.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jbi.component.Component;
import javax.jbi.messaging.MessageExchange;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.descriptor.original.generated.LinkType;
import org.ow2.petals.jbi.messaging.control.ExchangeCheckerClient;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.jbi.Adapter;
import org.petalslink.dsb.kernel.api.PetalsService;
import org.petalslink.dsb.kernel.api.messaging.EndpointSearchEngine;
import org.petalslink.dsb.kernel.api.messaging.SearchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointResolverModule
implements SenderModule,
PetalsService {
    protected LoggingUtil log;
    private EndpointSearchEngine endpointSearchEngine;
    private ConfigurationService configurationService;
    private ExchangeCheckerClient exchangeCheckerClient;

    public EndpointResolverModule(LoggingUtil loggingUtil) {
        this.log = loggingUtil;
    }

    public void init() throws Exception {
    }

    public void setup() throws Exception {
    }

    public void shutdown() throws Exception {
    }

    @Override
    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, org.ow2.petals.jbi.messaging.exchange.MessageExchange messageExchange) throws RoutingException {
        this.log.call();
        if (MessageExchange.Role.CONSUMER.equals(messageExchange.getRole())) {
            List<ServiceEndpoint> list = this.resolveEndpoints(componentContext.getComponent(), messageExchange);
            for (ServiceEndpoint serviceEndpoint : list) {
                map.put(serviceEndpoint, new TransportSendContext(serviceEndpoint.getLocation()));
            }
        } else {
            map.put(messageExchange.getConsumerEndpoint(), new TransportSendContext(messageExchange.getConsumerEndpoint().getLocation()));
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private List<ServiceEndpoint> resolveEndpoints(Component var1_1, org.ow2.petals.jbi.messaging.exchange.MessageExchange var2_2) throws RoutingException {
        this.log.start();
        var3_3 = (String)var2_2.getProperty("org.objectweb.petals.routing.strategy");
        var4_4 = (ServiceEndpoint)var2_2.getEndpoint();
        var5_5 = var2_2.getService();
        var6_6 = var2_2.getInterfaceName();
        var7_7 = LinkType.STANDARD.value();
        if (var2_2.getProperty("org.ow2.petals.router.provider.linktype") != null) {
            var7_7 = (String)var2_2.getProperty("org.ow2.petals.router.provider.linktype");
        }
        var8_8 = new ArrayList<Object>();
        if (var4_4 != null) {
            var9_9 = null;
            try {
                var10_12 /* !! */  = this.endpointSearchEngine.getTargetedEndpointFromGivenEndpoint(Adapter.createServiceEndpoint((org.ow2.petals.kernel.api.service.ServiceEndpoint)var4_4), var7_7);
                var9_9 = Adapter.createServiceEndpoint((org.petalslink.dsb.api.ServiceEndpoint)var10_12 /* !! */ );
            }
            catch (SearchException var10_13) {
                throw new RoutingException(var10_13);
            }
            if (var9_9 != null) {
                var8_8.add(var9_9);
            }
        } else if (var5_5 != null) {
            try {
                var9_9 = this.endpointSearchEngine.getTargetedEndpointFromGivenServiceName(var5_5, var3_3, var7_7);
                if (var9_9 == null) ** GOTO lbl48
                var11_14 = var9_9.iterator();
                while (var11_14.hasNext()) {
                    var10_12 /* !! */  = (org.petalslink.dsb.api.ServiceEndpoint)var11_14.next();
                    var8_8.add(Adapter.createServiceEndpoint((org.petalslink.dsb.api.ServiceEndpoint)var10_12 /* !! */ ));
                }
            }
            catch (SearchException var9_10) {
                throw new RoutingException(var9_10);
            }
        } else if (var6_6 != null) {
            try {
                var9_9 = this.endpointSearchEngine.getTargetedEndpointFromGivenInterfaceName(var6_6, var3_3, var7_7);
                if (var9_9 != null) {
                    var11_14 = var9_9.iterator();
                    while (var11_14.hasNext()) {
                        var10_12 /* !! */  = (org.petalslink.dsb.api.ServiceEndpoint)var11_14.next();
                        var8_8.add(Adapter.createServiceEndpoint((org.petalslink.dsb.api.ServiceEndpoint)var10_12 /* !! */ ));
                    }
                }
            }
            catch (SearchException var9_11) {
                throw new RoutingException(var9_11);
            }
        }
lbl48:
        // 6 sources

        var9_9 = new ArrayList<E>();
        if (var8_8 != null) {
            for (org.petalslink.dsb.api.ServiceEndpoint var10_12 : var8_8) {
                if (!this.controlAcceptationExchange(var1_1, (ServiceEndpoint)var10_12 /* !! */ , var2_2)) continue;
                var9_9.add(var10_12 /* !! */ );
            }
        }
        var9_9.size();
        this.log.end();
        return var9_9;
    }

    private boolean controlAcceptationExchange(Component component, ServiceEndpoint serviceEndpoint, org.ow2.petals.jbi.messaging.exchange.MessageExchange messageExchange) {
        this.log.call();
        boolean bl = false;
        if (this.configurationService.getContainerConfiguration().isExchangeValidation()) {
            if (component.isExchangeWithProviderOkay((javax.jbi.servicedesc.ServiceEndpoint)serviceEndpoint, (MessageExchange)messageExchange) && this.exchangeCheckerClient.isExchangeWithConsumerOkayForComponent(serviceEndpoint, messageExchange)) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void setEndpointSearchEngine(EndpointSearchEngine endpointSearchEngine) {
        this.endpointSearchEngine = endpointSearchEngine;
    }

    public EndpointSearchEngine getEndpointSearchEngine() {
        return this.endpointSearchEngine;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ExchangeCheckerClient getExchangeCheckerClient() {
        return this.exchangeCheckerClient;
    }

    public void setExchangeCheckerClient(ExchangeCheckerClient exchangeCheckerClient) {
        this.exchangeCheckerClient = exchangeCheckerClient;
    }
}

