/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistryMBean;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.api.messaging.RegistryListenerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndpointRegistry
implements EndpointRegistry,
RegistryListenerManager {
    protected LoggingUtil log;

    @Override
    public List<Map<String, Object>> getAllEndpoints() {
        List<Map<String, Object>> list = this.getAllExternalEndpoints();
        list.addAll(this.getAllInternalEndpoints());
        return list;
    }

    @Override
    public List<Map<String, Object>> getAllInternalEndpoints() {
        this.log.start();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        List<ServiceEndpoint> list = null;
        try {
            list = this.getInternalEndpoints();
        }
        catch (RegistryException registryException) {
            this.log.warning(registryException.getMessage());
            return arrayList;
        }
        for (ServiceEndpoint serviceEndpoint : list) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("componentName", serviceEndpoint.getLocation().getComponentName());
            hashMap.put("containerName", serviceEndpoint.getLocation().getContainerName());
            hashMap.put("endpointName", serviceEndpoint.getEndpointName());
            hashMap.put("serviceName", serviceEndpoint.getServiceName().toString());
            List<String> list2 = AbstractEndpointRegistry.interfaceQNameToString(serviceEndpoint);
            hashMap.put("interfaceNames", list2.toArray(new String[list2.size()]));
            hashMap.put("type", EndpointRegistryMBean.TYPE_INTERNAL);
            arrayList.add(hashMap);
        }
        this.log.end();
        return arrayList;
    }

    @Override
    public List<Map<String, Object>> getAllExternalEndpoints() {
        List<ServiceEndpoint> list;
        this.log.start();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        try {
            list = this.getExternalEndpoints();
        }
        catch (RegistryException registryException) {
            this.log.warning(registryException.getMessage());
            return arrayList;
        }
        for (ServiceEndpoint serviceEndpoint : list) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("componentName", serviceEndpoint.getLocation().getComponentName());
            hashMap.put("containerName", serviceEndpoint.getLocation().getContainerName());
            hashMap.put("endpointName", serviceEndpoint.getEndpointName());
            hashMap.put("serviceName", serviceEndpoint.getServiceName());
            List<String> list2 = AbstractEndpointRegistry.interfaceQNameToString(serviceEndpoint);
            hashMap.put("interfaceNames", list2.toArray(new String[list2.size()]));
            hashMap.put("type", EndpointRegistryMBean.TYPE_EXTERNAL);
            arrayList.add(hashMap);
        }
        this.log.end();
        return arrayList;
    }

    protected static final List<String> interfaceQNameToString(ServiceEndpoint serviceEndpoint) {
        QName[] qNameArray = serviceEndpoint.getInterfaces();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (qNameArray != null && qNameArray.length > 0) {
            QName[] qNameArray2 = qNameArray;
            int n = qNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                QName qName = qNameArray2[n2];
                arrayList.add(qName.toString());
                ++n2;
            }
        } else {
            arrayList.add("undefined");
        }
        return arrayList;
    }

    @Override
    public List<ServiceEndpoint> getEndpoints() {
        ArrayList<ServiceEndpoint> arrayList = new ArrayList<ServiceEndpoint>();
        try {
            List<ServiceEndpoint> list = this.getInternalEndpoints();
            if (list != null) {
                arrayList.addAll(list);
            }
            if ((list = this.getExternalEndpoints()) != null) {
                arrayList.addAll(list);
            }
        }
        catch (RegistryException registryException) {
            this.log.warning(registryException.getMessage());
        }
        return arrayList;
    }
}

