/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryListener;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.config.Configuration;
import org.ow2.petals.registry.api.config.ConfigurationLoader;
import org.ow2.petals.registry.api.config.ConfigurationLoaderFactory;
import org.ow2.petals.registry.api.config.RemoteConfiguration;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.client.RegistryClientFactory;
import org.ow2.petals.registry.core.factory.RegistryFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.api.DSBException;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.jbi.Adapter;
import org.petalslink.dsb.kernel.api.PetalsService;
import org.petalslink.dsb.kernel.api.messaging.RegistryListenerManager;
import org.petalslink.dsb.kernel.registry.BaseEndpointRegistry;
import org.petalslink.dsb.kernel.registry.RegistryListenerManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointRegistryImpl
extends BaseEndpointRegistry
implements EndpointRegistry,
PetalsService,
RegistryListenerManager {
    protected ConfigurationService configurationService;
    protected TopologyService localTopologyService;
    protected List<RegistryListener> registryListeners = new ArrayList<RegistryListener>();
    protected ContainerConfiguration localContainerConfiguration;
    private ScheduledExecutorService registryTopologyUpdater;
    private Configuration localConfig;
    private boolean registeredOnMaster = false;
    protected RegistryListenerManager listenerManager;

    public EndpointRegistryImpl(LoggingUtil loggingUtil) {
        this.log = loggingUtil;
        this.listenerManager = new RegistryListenerManagerImpl();
    }

    public void init() throws Exception {
        this.log.call();
    }

    public void setup() throws Exception {
        this.log.call();
        this.localContainerConfiguration = this.configurationService.getContainerConfiguration();
        URL uRL = this.getClass().getResource("/server.properties");
        if (uRL == null) {
            throw new IOException("Registry configuration file has not been found, check classpath for /server.properties");
        }
        File file = new File(uRL.toURI());
        try {
            this.createRegistryConfig(file);
            this.loadRegistry();
            this.createRegistryTopology();
            this.registry.init();
            this.registry.start();
            this.cleanData();
        }
        catch (RegistryException registryException) {
            this.log.error(registryException.getMessage(), registryException);
            if (this.registry != null && (this.registry.isInitialized() || this.registry.isStarted())) {
                try {
                    this.registry.stop();
                }
                catch (LifeCycleException lifeCycleException) {
                    throw new org.ow2.petals.jbi.messaging.registry.RegistryException(lifeCycleException);
                }
            }
            throw new org.ow2.petals.jbi.messaging.registry.RegistryException(registryException);
        }
        this.createTopologyUpdater();
        try {
            this.registry.synchronizeData();
        }
        catch (RegistryException registryException) {
            if (this.log.isDebugEnabled()) {
                this.log.warning("Can not synchronize data from network, mode will be downgraded", registryException);
            }
            this.log.warning("Can not synchronize data from network, mode will be downgraded");
        }
        this.client = RegistryClientFactory.getNewClient((LocalRegistry)this.registry);
        this.log.info("The registry is ready process requests on " + this.registry.getContext().getConfiguration().getMessageReceiverURL());
    }

    protected void loadRegistry() throws PetalsException, RegistryException {
        this.registry = RegistryFactory.getInstance().loadLocal(this.localConfig);
        if (this.registry == null) {
            throw new PetalsException("Registry can not be loaded!");
        }
    }

    protected void createTopologyUpdater() {
        if (this.localTopologyService.hasValidLocalContainerDynamicTopologyConfiguration()) {
            long l = this.configurationService.getContainerConfiguration().getTopologyUpdatePeriod();
            this.registryTopologyUpdater = Executors.newSingleThreadScheduledExecutor();
            this.registryTopologyUpdater.scheduleAtFixedRate(new TopologyUpdater(), 30L, l, TimeUnit.SECONDS);
            try {
                this.localTopologyService.registerLocalContainerOnMaster();
                this.localTopologyService.updateTopology();
                this.registeredOnMaster = true;
            }
            catch (Throwable throwable) {
                this.registeredOnMaster = false;
                this.log.warning("Can't register local node onto the master node (nor updating the topology)");
            }
        }
    }

    protected void createRegistryTopology() throws PetalsException {
        Set<ContainerConfiguration> set = this.localTopologyService.getContainersConfiguration(null);
        String string = null;
        for (ContainerConfiguration containerConfiguration : set) {
            if (!containerConfiguration.getName().equals(this.localContainerConfiguration.getName())) continue;
            string = containerConfiguration.getSubdomainName();
            break;
        }
        ArrayList<ContainerConfiguration> arrayList = new ArrayList<ContainerConfiguration>();
        for (ContainerConfiguration containerConfiguration : set) {
            if (!containerConfiguration.getSubdomainName().equals(string) || containerConfiguration.getSubdomainName().equals(this.localContainerConfiguration.getName()) || !containerConfiguration.getRegistryMode().equals((Object)ContainerConfiguration.RegistryMode.MASTER) && !containerConfiguration.getRegistryMode().equals((Object)ContainerConfiguration.RegistryMode.PEER)) continue;
            arrayList.add(containerConfiguration);
        }
        if (this.localContainerConfiguration.isSlave() || this.localContainerConfiguration.isPeer()) {
            for (ContainerConfiguration containerConfiguration : arrayList) {
                RemoteConfiguration remoteConfiguration = new RemoteConfiguration("Registry@PETALSESB-" + containerConfiguration.getName());
                remoteConfiguration.setMessageSenderClassName(this.localConfig.getMessageSenderClassName());
                String string2 = "http://" + containerConfiguration.getHost() + ":" + containerConfiguration.getWebservicePort();
                remoteConfiguration.setUri(string2);
                this.registry.getContext().getTopology().add(remoteConfiguration);
            }
        }
        if (this.localContainerConfiguration.isPeer()) {
            this.registry.getContext().getProperties().put("registry.mode", "peer");
        }
        if (this.localContainerConfiguration.isMaster()) {
            this.registry.getContext().getProperties().put("registry.mode", "master");
        }
        if (this.localContainerConfiguration.isSlave()) {
            this.registry.getContext().getProperties().put("registry.mode", "slave");
        }
        if (this.localContainerConfiguration.isStandalone()) {
            this.registry.getContext().getProperties().put("registry.mode", "standalone");
        }
    }

    protected void createRegistryConfig(File file) throws RegistryException {
        ConfigurationLoader configurationLoader = ConfigurationLoaderFactory.getLoader((File)file);
        if (configurationLoader == null) {
            throw new RegistryException("Can not get a configuration loader for the file " + file.getName());
        }
        try {
            this.localConfig = configurationLoader.loadLocal((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RegistryException((Throwable)fileNotFoundException);
        }
        this.localConfig.setName("Registry@PEtALSESB-" + this.localContainerConfiguration.getName());
        this.localConfig.setRootPath(this.localContainerConfiguration.getWorkDirectoryPath());
        String string = "http://" + this.localContainerConfiguration.getHost() + ":" + this.localContainerConfiguration.getWebservicePort();
        this.localConfig.setMessageReceiverURL(string);
    }

    private void cleanData() {
        block5: {
            block4: {
                this.registry.pauseReceive();
                try {
                    this.registry.delete(this.getRootPath(), true);
                }
                catch (RegistryException registryException) {
                    if (!this.log.isErrorEnabled()) break block4;
                    this.log.error(registryException.getMessage());
                }
            }
            try {
                this.registry.clean();
            }
            catch (RegistryException registryException) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error(registryException.getMessage());
            }
        }
        this.registry.resumeReceive();
    }

    public void shutdown() throws Exception {
        block9: {
            block8: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Stopping...");
                }
                this.registry.pauseReceive();
                try {
                    this.registry.cleanRemoteData();
                }
                catch (RegistryException registryException) {
                    if (!this.log.isErrorEnabled()) break block8;
                    this.log.error(registryException.getMessage());
                }
            }
            try {
                this.registry.delete(this.getRootPath(), true);
            }
            catch (RegistryException registryException) {
                if (!this.log.isErrorEnabled()) break block9;
                this.log.error(registryException.getMessage());
            }
        }
        if (this.registryTopologyUpdater != null) {
            this.registryTopologyUpdater.shutdownNow();
        }
        try {
            this.registry.stop();
        }
        catch (LifeCycleException lifeCycleException) {
            throw new org.ow2.petals.jbi.messaging.registry.RegistryException(lifeCycleException);
        }
    }

    @Override
    protected final String getRootPath() {
        return "/endpoints/" + this.configurationService.getContainerConfiguration().getName() + "/";
    }

    @Override
    public List<RegistryListener> getListeners() {
        return this.registryListeners;
    }

    public void addListener(RegistryListener registryListener) throws DSBException {
        if (this.registryListeners == null) {
            this.registryListeners = new ArrayList<RegistryListener>();
        }
        if (registryListener == null) {
            throw new DSBException("The listener can not be null");
        }
        this.registryListeners.add(registryListener);
    }

    @Override
    public void synchronizeData() throws org.ow2.petals.jbi.messaging.registry.RegistryException {
        if (this.registry == null) {
            throw new org.ow2.petals.jbi.messaging.registry.RegistryException("Registry is null and can not be managed!");
        }
        try {
            this.registry.synchronizeData();
        }
        catch (RegistryException registryException) {
            throw new org.ow2.petals.jbi.messaging.registry.RegistryException(registryException);
        }
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public TopologyService getTopologyService() {
        return this.localTopologyService;
    }

    public void setTopologyService(TopologyService topologyService) {
        this.localTopologyService = topologyService;
    }

    public void setListeners(Hashtable<String, Object> hashtable) {
        if (hashtable != null) {
            for (Object object : hashtable.values()) {
                if (object == null || !(object instanceof RegistryListener)) continue;
                try {
                    this.addListener((RegistryListener)object);
                }
                catch (DSBException dSBException) {}
            }
            for (final String string : hashtable.keySet()) {
                Object object = hashtable.get(string);
                if (object == null || !(object instanceof RegistryListener)) continue;
                final RegistryListener registryListener = (RegistryListener)object;
                try {
                    this.add(new org.petalslink.dsb.kernel.api.messaging.RegistryListener(){

                        public void onUnregister(ServiceEndpoint serviceEndpoint) throws DSBException {
                            EndpointRegistryImpl.this.log.call("Calling onUnregister in registry listener '" + this.getName() + "' for " + serviceEndpoint.toString());
                            registryListener.onUnregister(Adapter.createServiceEndpoint((ServiceEndpoint)serviceEndpoint));
                        }

                        public void onRegister(ServiceEndpoint serviceEndpoint) throws DSBException {
                            EndpointRegistryImpl.this.log.call("Calling onRegister in registry listener '" + this.getName() + "' for " + serviceEndpoint.toString());
                            registryListener.onUnregister(Adapter.createServiceEndpoint((ServiceEndpoint)serviceEndpoint));
                        }

                        public String getName() {
                            return string;
                        }
                    });
                }
                catch (DSBException dSBException) {
                    dSBException.printStackTrace();
                }
            }
        }
    }

    public List<org.petalslink.dsb.kernel.api.messaging.RegistryListener> getList() {
        return this.listenerManager.getList();
    }

    public void add(org.petalslink.dsb.kernel.api.messaging.RegistryListener registryListener) throws DSBException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding a registry listener " + registryListener.getName());
        }
        this.listenerManager.add(registryListener);
    }

    public org.petalslink.dsb.kernel.api.messaging.RegistryListener get(String string) throws DSBException {
        return this.listenerManager.get(string);
    }

    public org.petalslink.dsb.kernel.api.messaging.RegistryListener remove(String string) throws DSBException {
        return this.listenerManager.remove(string);
    }

    public void setState(String string, boolean bl) {
        this.listenerManager.setState(string, bl);
    }

    public boolean getState(String string) {
        return this.listenerManager.getState(string);
    }

    class TopologyExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        TopologyExceptionHandler() {
        }

        public void uncaughtException(Thread thread, Throwable throwable) {
            EndpointRegistryImpl.this.log.error(String.valueOf(throwable.getMessage()) + " : " + throwable.getCause());
        }
    }

    class TopologyUpdater
    implements Runnable {
        TopologyUpdater() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    EndpointRegistryImpl.this.registry.pauseReceive();
                    if (!EndpointRegistryImpl.this.registeredOnMaster) {
                        EndpointRegistryImpl.this.localTopologyService.registerLocalContainerOnMaster();
                        EndpointRegistryImpl.this.registeredOnMaster = true;
                    }
                    EndpointRegistryImpl.this.localTopologyService.updateTopology();
                    Set<ContainerConfiguration> set = EndpointRegistryImpl.this.localTopologyService.getContainersConfigurationsForLocalSubdomain();
                    for (ContainerConfiguration containerConfiguration : set) {
                        RemoteConfiguration remoteConfiguration = new RemoteConfiguration("Registry@PETALSESB-" + containerConfiguration.getName());
                        remoteConfiguration.setMessageSenderClassName(EndpointRegistryImpl.this.localConfig.getMessageSenderClassName());
                        String string = "http://" + containerConfiguration.getHost() + ":" + containerConfiguration.getWebservicePort();
                        remoteConfiguration.setUri(string);
                        EndpointRegistryImpl.this.registry.getContext().getTopology().add(remoteConfiguration);
                    }
                }
                catch (Throwable throwable) {
                    EndpointRegistryImpl.this.registeredOnMaster = false;
                    EndpointRegistryImpl.this.log.warning("Can't synchronize local topology with master topology : " + throwable.getCause());
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                EndpointRegistryImpl.this.registry.resumeReceive();
                throw throwable;
            }
            {
                Object var6_9 = null;
            }
            EndpointRegistryImpl.this.registry.resumeReceive();
        }
    }
}

