/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.registry.jndi;

import java.util.Set;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.communication.jndi.client.JNDIService;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.registry.LocalResourceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDILocalResourceRegistryImpl
implements LifeCycleController,
LocalResourceRegistry {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;
    @Requires(name="jndi", signature=JNDIService.class)
    private JNDIService jndiService;
    private Context usersContext;
    private boolean created = false;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug("Starting...");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug("Stopping...");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public synchronized void create() {
        if (!this.created) {
            try {
                this.usersContext = this.jndiService.getUsersContext();
            }
            catch (NamingException namingException) {
                this.log.warning(namingException.getMessage());
            }
        }
        this.created = true;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    @Override
    public void createComponent(String string) {
        this.create();
        try {
            this.usersContext.createSubcontext(string);
        }
        catch (Exception exception) {
            this.log.warning("Exception while creating component context : " + exception.getMessage());
        }
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public Set<String> getExposedServiceURLs(String string) {
        Set set = null;
        try {
            NamingEnumeration<Binding> namingEnumeration = this.usersContext.listBindings(string);
            while (namingEnumeration.hasMoreElements()) {
                Binding binding = (Binding)namingEnumeration.nextElement();
                Object object = binding.getObject();
                if (object instanceof Context) {
                    Context context = (Context)object;
                    Object object2 = context.lookup("services");
                    if (object2 != null) {
                        if (object2 instanceof Set) {
                            set = (Set)object2;
                            continue;
                        }
                        this.log.warning("URLs can not be retrieved");
                        continue;
                    }
                    this.log.warning("Can not find services in component context");
                    continue;
                }
                this.log.warning("This is not a good context for binding " + binding.getName());
            }
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
        return set;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public Object getResource(String string) {
        Object object = null;
        String string2 = string;
        if (string2 != null && string2.length() >= 1 && string2.indexOf(47) == 0) {
            string2 = string2.substring(1, string2.length());
        }
        if (string2.lastIndexOf(47) == string2.length()) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String[] stringArray = string2.split("/");
        Context context = this.usersContext;
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            Object object2 = null;
            try {
                object2 = context.lookup(string3);
            }
            catch (NamingException namingException) {
                namingException.printStackTrace();
            }
            if (object2 == null) {
                System.out.println("Returning null for current key = " + string3);
                return null;
            }
            if (n < stringArray.length && object2 != null && object2 instanceof Context) {
                context = (Context)object2;
            } else {
                object = object2;
            }
            ++n;
        }
        return object;
    }

    @Override
    public void putResource(String string, Object object) {
        String string2 = string;
        if (string2 != null && string2.length() >= 1 && string2.indexOf(47) == 0) {
            string2 = string2.substring(1, string2.length());
        }
        if (string2.lastIndexOf(47) == string2.length()) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        String[] stringArray = string2.split("/");
        Context context = this.usersContext;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray2[n2];
            System.out.println("Creating context " + string3);
            try {
                context = context.createSubcontext(string3);
            }
            catch (NamingException namingException) {
                try {
                    context = (Context)context.lookup(string3);
                }
                catch (NamingException namingException2) {}
            }
            ++n2;
        }
    }
}

