/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.tools.ws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.tools.ws.WebServiceHelper;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceException;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceExposer;
import org.petalslink.dsb.kernel.api.tools.ws.WebServiceInformationBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=WebServiceExposer.class)})
public class CXFWebServiceExposerImpl
implements BindingController,
LifeCycleController,
WebServiceExposer {
    private LoggerFactory loggerFactory;
    private Logger logger;
    private LoggingUtil log;
    @Requires(name="configuration", signature=ConfigurationService.class)
    protected ConfigurationService configurationService;
    protected Map<String, Server> servers;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug("Starting...");
        this.servers = new HashMap<String, Server>();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug("Stopping...");
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public Set<WebServiceInformationBean> expose(Set<WebServiceInformationBean> set) {
        HashSet<WebServiceInformationBean> hashSet = new HashSet<WebServiceInformationBean>();
        for (WebServiceInformationBean webServiceInformationBean : set) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Exposing component " + webServiceInformationBean.componentName + " as web service");
            }
            WebServiceInformationBean webServiceInformationBean2 = null;
            try {
                webServiceInformationBean2 = this.exposeAsWebService(webServiceInformationBean);
            }
            catch (WebServiceException webServiceException) {
                this.log.warning(webServiceException.getMessage());
            }
            if (webServiceInformationBean2 == null) continue;
            hashSet.add(webServiceInformationBean2);
        }
        return hashSet;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected WebServiceInformationBean exposeAsWebService(WebServiceInformationBean webServiceInformationBean) throws WebServiceException {
        if (webServiceInformationBean == null || webServiceInformationBean.implem == null) {
            throw new WebServiceException("Can not create a web service from null things...");
        }
        if (this.isAlreadyRegistered(webServiceInformationBean)) {
            throw new WebServiceException(String.format("The service provided by component %s is already registered", webServiceInformationBean.componentName));
        }
        WebServiceInformationBean webServiceInformationBean2 = webServiceInformationBean;
        JaxWsServerFactoryBean jaxWsServerFactoryBean = new JaxWsServerFactoryBean();
        jaxWsServerFactoryBean.setDataBinding((DataBinding)new JAXBDataBinding());
        jaxWsServerFactoryBean.setServiceBean(webServiceInformationBean.implem);
        String string = null;
        Class<?> clazz = WebServiceHelper.getWebServiceClass(webServiceInformationBean.implem.getClass());
        if (clazz == null) {
            throw new WebServiceException(String.format("Can not find the class definition of the component to expose for component %s", webServiceInformationBean.componentName));
        }
        string = WebServiceHelper.getWebServiceName(clazz);
        if (string == null || this.servers.get(string) != null) {
            string = webServiceInformationBean.implem.getClass().getSimpleName();
        }
        webServiceInformationBean2.name = string;
        jaxWsServerFactoryBean.setServiceClass(clazz);
        String string2 = null;
        string2 = webServiceInformationBean.url == null ? this.getURL(string) : webServiceInformationBean.url;
        String string3 = String.valueOf(string2) + "?wsdl";
        if (this.log.isDebugEnabled()) {
            this.log.debug("Service URL is " + string2);
            this.log.debug("Service WSDL is " + string3);
        }
        webServiceInformationBean2.url = string2;
        jaxWsServerFactoryBean.setAddress(string2);
        Server server = jaxWsServerFactoryBean.create();
        this.servers.put(string, server);
        if (this.log.isInfoEnabled()) {
            this.log.info("Kernel Component '" + webServiceInformationBean.componentName + "' has been exposed and is available at '" + string2 + "'");
        }
        return webServiceInformationBean2;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    protected boolean isAlreadyRegistered(WebServiceInformationBean webServiceInformationBean) {
        String string = WebServiceHelper.getWebServiceName(webServiceInformationBean.getClazz());
        if (string == null) {
            string = WebServiceHelper.getWebServiceName(webServiceInformationBean.getClazz());
        }
        return string == null ? false : this.servers.get(string) != null;
    }

    protected String getURL(String string) {
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
        String string2 = containerConfiguration.getWebservicePrefix();
        string2 = string2 == null ? "petals/ws" : string2.trim();
        int n = containerConfiguration.getWebservicePort();
        if (n <= 0) {
            n = 9001;
        }
        return "http://" + containerConfiguration.getHost() + ":" + n + "/" + string2 + "/" + string;
    }

    public void remove(String string) throws WebServiceException {
        Server server = this.servers.get(string);
        if (server != null) {
            try {
                server.stop();
            }
            catch (Throwable throwable) {
                String string2 = "Web Service " + string + " can not be removed";
                if (this.log.isWarnEnabled()) {
                    this.log.warning(string2, throwable);
                }
                throw new WebServiceException(string2, throwable);
            }
            this.servers.remove(string);
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

