/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.ws;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.dragon.connection.api.to.Endpoint;
import org.ow2.dragon.connection.api.to.EnvironmentFederation;
import org.ow2.dragon.connection.api.to.ExecutionEnvironment;
import org.ow2.dragon.connection.api.to.ExecutionEnvironmentManager;
import org.ow2.dragon.connection.api.to.Processor;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlException;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.jbi.management.admin.AdminService;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.registry.EndpointRegistry;
import org.ow2.petals.jbi.messaging.registry.RegistryException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.util.LoggingUtil;
import org.ow2.petals.util.XMLUtil;
import org.petalslink.dsb.kernel.ws.api.MasterConnectionService;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=MasterConnectionService.class)})
public class MasterConnectionServiceImpl
implements BindingController,
LifeCycleController,
MasterConnectionService {
    private LoggerFactory loggerFactory;
    private Component component;
    private Logger logger;
    @Requires(name="endpoint", signature=EndpointRegistry.class)
    private EndpointRegistry endpointRegistry;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(contingency=Contingency.OPTIONAL, name="topology", signature=TopologyService.class)
    private TopologyService topologyService;
    @Requires(name="adminService", signature=AdminService.class)
    private AdminService adminService;
    private LoggingUtil log;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug("Starting...");
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug("Stopping...");
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public Component getComponent() {
        return this.component;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public List<ExecutionEnvironment> getFederationMembers(String string) {
        ArrayList<ExecutionEnvironment> arrayList = new ArrayList<ExecutionEnvironment>();
        Set<ContainerConfiguration> set = this.getContainersConfiguration();
        for (ContainerConfiguration containerConfiguration : set) {
            if (!this.isInFederation(containerConfiguration, string)) continue;
            arrayList.add(this.getExecutionEnvironment(containerConfiguration));
        }
        return arrayList;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public List<Endpoint> getHostedEndpointsOnExecEnv(String string) {
        return this.getEndpointsForContainer(string);
    }

    @Override
    public List<Endpoint> getHostedEndpointsOnProcessor(String string) {
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        Set<ContainerConfiguration> set = this.getContainersForProcessor(string);
        for (ContainerConfiguration containerConfiguration : set) {
            arrayList.addAll(this.getEndpointsForContainer(containerConfiguration.getName()));
        }
        return arrayList;
    }

    @Override
    public List<ExecutionEnvironment> getManagedExecutionEnvironments() {
        ArrayList<ExecutionEnvironment> arrayList = new ArrayList<ExecutionEnvironment>();
        Set<ContainerConfiguration> set = this.getContainersConfiguration();
        for (ContainerConfiguration containerConfiguration : set) {
            arrayList.add(this.getExecutionEnvironment(containerConfiguration));
        }
        return arrayList;
    }

    @Override
    public ExecutionEnvironmentManager getProperties() {
        ExecutionEnvironmentManager executionEnvironmentManager = new ExecutionEnvironmentManager();
        executionEnvironmentManager.setName("Manager@PEtALS-ESB:" + this.configurationService.getContainerConfiguration().getName());
        return executionEnvironmentManager;
    }

    private ExecutionEnvironment getExecutionEnvironment(ContainerConfiguration containerConfiguration) {
        EnvironmentFederation environmentFederation = new EnvironmentFederation();
        environmentFederation.setName(this.configurationService.getDomainConfiguration().getName());
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironment();
        executionEnvironment.setIpv4Address(containerConfiguration.getHost());
        executionEnvironment.setEnvType(ExecutionEnvironment.EEType.ESB);
        executionEnvironment.setType("PEtALS");
        executionEnvironment.setVersion(this.adminService.getSystemInfo());
        executionEnvironment.setName(containerConfiguration.getName());
        if (this.isStandalone()) {
            executionEnvironment.setRoleInFederation("standalone");
        } else {
            executionEnvironment.setRoleInFederation("peer");
        }
        environmentFederation.setPattern(EnvironmentFederation.FedPattern.DISTRIBUTED);
        executionEnvironment.setParentFederation(environmentFederation);
        List<Endpoint> list = this.getEndpointsForContainer(containerConfiguration.getName());
        executionEnvironment.setEndpoints(list);
        executionEnvironment.setHostProcessor(this.getProcessor(containerConfiguration));
        executionEnvironment.setProperties(this.getProperties(containerConfiguration));
        return executionEnvironment;
    }

    private Set<ContainerConfiguration> getContainersConfiguration() {
        Set<ContainerConfiguration> set = null;
        if (this.isStandalone()) {
            ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
            set = new HashSet<ContainerConfiguration>();
            set.add(containerConfiguration);
        } else {
            set = this.topologyService.getContainersConfiguration(null);
        }
        return set;
    }

    private List<Endpoint> getEndpointsForContainer(String string) {
        List<ServiceEndpoint> list;
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        try {
            list = this.endpointRegistry.getEndpoints();
        }
        catch (RegistryException registryException) {
            return arrayList;
        }
        for (ServiceEndpoint serviceEndpoint : list) {
            if (!string.equals(serviceEndpoint.getLocation().getContainerName())) continue;
            Endpoint endpoint = new Endpoint();
            QName qName = QName.valueOf(serviceEndpoint.getEndpointName());
            endpoint.setName(qName);
            try {
                Description description = WSDL4ComplexWsdlFactory.newInstance().newWSDLReader().read(serviceEndpoint.getDescription());
                Map map = description.deleteImportedDocumentsInWsdl();
                String string2 = WSDL4ComplexWsdlFactory.newInstance().newWSDLWriter().writeWSDL4ComplexWsdl(description);
                endpoint.setWsdlDescription(string2);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (map != null) {
                    for (URI uRI : map.keySet()) {
                        try {
                            hashMap.put(uRI.toString(), XMLUtil.createStringFromDOMDocument((Node)map.get(uRI)));
                        }
                        catch (TransformerException transformerException) {
                            this.log.warning(transformerException.getMessage());
                        }
                    }
                }
                endpoint.setWsdlDescriptionImports(hashMap);
                endpoint.setWsdlDescriptionImports(hashMap);
                arrayList.add(endpoint);
            }
            catch (WSDL4ComplexWsdlException wSDL4ComplexWsdlException) {
                this.log.warning(wSDL4ComplexWsdlException.getMessage());
            }
            catch (URISyntaxException uRISyntaxException) {
                this.log.warning(uRISyntaxException.getMessage());
            }
        }
        return arrayList;
    }

    private Processor getProcessor(ContainerConfiguration containerConfiguration) {
        Processor processor = new Processor();
        processor.setIpv4Address(containerConfiguration.getHost());
        processor.setName("ProcessorName-" + containerConfiguration.getName());
        processor.setType("Unknown");
        return processor;
    }

    private List<String> getProperties(ContainerConfiguration containerConfiguration) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Description=" + containerConfiguration.getDescription());
        arrayList.add("State=" + (Object)((Object)containerConfiguration.getState()));
        return arrayList;
    }

    private Set<ContainerConfiguration> getContainersForProcessor(String string) {
        HashSet<ContainerConfiguration> hashSet = new HashSet<ContainerConfiguration>();
        Set<ContainerConfiguration> set = this.getContainersConfiguration();
        for (ContainerConfiguration containerConfiguration : set) {
            if (!string.equals(containerConfiguration.getName())) continue;
            hashSet.add(containerConfiguration);
        }
        return hashSet;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("endpoint")) {
            if (!EndpointRegistry.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + EndpointRegistry.class.getName());
            }
            this.endpointRegistry = (EndpointRegistry)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("topology")) {
            if (!TopologyService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + TopologyService.class.getName());
            }
            this.topologyService = (TopologyService)object;
            return;
        }
        if (string.equals("adminService")) {
            if (!AdminService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + AdminService.class.getName());
            }
            this.adminService = (AdminService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private boolean isInFederation(ContainerConfiguration containerConfiguration, String string) {
        return string.equals(containerConfiguration.getSubdomainName());
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("endpoint");
        arrayList.add("configuration");
        arrayList.add("topology");
        arrayList.add("adminService");
        return arrayList.toArray(new String[0]);
    }

    private boolean isStandalone() {
        return this.topologyService == null;
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("endpoint")) {
            return this.endpointRegistry;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("topology")) {
            return this.topologyService;
        }
        if (string.equals("adminService")) {
            return this.adminService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("endpoint")) {
            this.endpointRegistry = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("topology")) {
            this.topologyService = null;
            return;
        }
        if (string.equals("adminService")) {
            this.adminService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

