/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.dsb.kernel.wsn;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.util.LoggingUtil;
import org.petalslink.dsb.annotations.LifeCycleListener;
import org.petalslink.dsb.annotations.Phase;
import org.petalslink.dsb.api.ServiceEndpoint;
import org.petalslink.dsb.kernel.io.client.ClientFactoryRegistry;
import org.petalslink.dsb.kernel.wsn.NotificationBootstrap;
import org.petalslink.dsb.notification.commons.PropertiesConfigurationConsumer;
import org.petalslink.dsb.service.client.Client;
import org.petalslink.dsb.service.client.Message;
import org.petalslink.dsb.service.client.WSAMessageImpl;
import org.w3c.dom.Document;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=NotificationBootstrap.class)})
public class NotificationBootstrapImpl
implements BindingController,
LifeCycleController,
NotificationBootstrap {
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycleListener(phase=Phase.START, priority=0)
    public void subscribeToProducers() {
        this.subscribeTo();
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void subscribeTo() {
        block12: {
            URL uRL = NotificationBootstrapImpl.class.getClassLoader().getResource("consumer.cfg");
            Properties properties = null;
            if (uRL != null) {
                properties = new Properties();
                try {
                    properties.load(NotificationBootstrapImpl.class.getClassLoader().getResourceAsStream("consumer.cfg"));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (properties == null) break block12;
            PropertiesConfigurationConsumer propertiesConfigurationConsumer = new PropertiesConfigurationConsumer(properties);
            Map map = propertiesConfigurationConsumer.getSubscribes();
            for (String string : map.keySet()) {
                block13: {
                    if (string == null) break block13;
                    if (this.log.isInfoEnabled()) {
                        this.log.info(String.format("Sending subscribe to %s", string));
                    }
                    List list = (List)map.get(string);
                    for (Subscribe subscribe : list) {
                        Object var17_19;
                        URI uRI = URI.create(string);
                        ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
                        String string2 = String.format("http://petals.ow2.org/wsa/%s/", uRI.getScheme());
                        serviceEndpoint.setEndpointName("WSAEndpoint");
                        serviceEndpoint.setServiceName(new QName(string2, "WSAService"));
                        serviceEndpoint.setInterfaces(new QName[]{new QName(string2, "WSAInterface")});
                        QName qName = WsnbConstants.SUBSCRIBE_QNAME;
                        WSAMessageImpl wSAMessageImpl = new WSAMessageImpl(string);
                        wSAMessageImpl.setOperation(qName);
                        Client client = null;
                        try {
                            try {
                                Document document = Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(subscribe);
                                wSAMessageImpl.setPayload(document);
                                client = ClientFactoryRegistry.getFactory().getClient(serviceEndpoint);
                                if (client != null) {
                                    client.fireAndForget((Message)wSAMessageImpl);
                                }
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        catch (Throwable throwable) {
                            var17_19 = null;
                            throw throwable;
                        }
                        {
                            var17_19 = null;
                        }
                    }
                    continue;
                }
                if (!this.log.isInfoEnabled()) continue;
                this.log.info(String.format("No address found to send subscribe", ""));
            }
        }
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

