/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.monitoring.router;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.exchange.MessageExchange;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.monitoring.router.Monitoring;
import org.ow2.petals.monitoring.router.RouterMonitor;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RouterService.class)})
public class RouterMonitorImpl
implements BindingController,
LifeCycleController,
RouterService,
RouterMonitor {
    protected LoggingUtil log;
    private LoggerFactory loggerFactory;
    protected Logger logger;
    private boolean monitoring = false;
    private Monitoring monitoring_util;
    @Requires(name="router", signature=RouterService.class)
    private RouterService router;
    private boolean showMessageContent = false;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void activateMonitoring(boolean bl) {
        this.monitoring = true;
        this.showMessageContent = bl;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void addComponent(ComponentContext componentContext) throws RoutingException {
        this.router.addComponent(componentContext);
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void deactivateMonitoring() {
        this.monitoring = false;
        this.showMessageContent = false;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public boolean isMessageContentShown() {
        return this.showMessageContent;
    }

    @Override
    public void showMessageContent(boolean bl) {
        this.showMessageContent = bl;
    }

    @Override
    public boolean isMonitoring() {
        return this.monitoring;
    }

    public MessageExchange receive(ComponentContext componentContext, long l) throws RoutingException {
        MessageExchange messageExchange = this.router.receive(componentContext, l);
        if (this.monitoring && messageExchange != null) {
            this.report(messageExchange);
        }
        return messageExchange;
    }

    public void removeComponent(ComponentContext componentContext) throws RoutingException {
        this.router.removeComponent(componentContext);
    }

    public void send(ComponentContext componentContext, MessageExchange messageExchange) throws RoutingException {
        if (this.monitoring && messageExchange != null) {
            this.report(messageExchange);
        }
        this.router.send(componentContext, messageExchange);
    }

    public MessageExchange sendSync(ComponentContext componentContext, MessageExchange messageExchange, long l) throws RoutingException {
        if (this.monitoring && messageExchange != null) {
            this.report(messageExchange);
        }
        MessageExchange messageExchange2 = this.router.sendSync(componentContext, messageExchange, l);
        if (this.monitoring && messageExchange != null) {
            this.report(messageExchange2);
        }
        return messageExchange2;
    }

    public void modifiedSALifeCycle(List<ServiceUnitLifeCycle> list) {
        this.router.modifiedSALifeCycle(list);
    }

    public void stopTraffic() {
        this.router.stopTraffic();
    }

    public void setMonitoring_util(Monitoring monitoring) {
        this.monitoring_util = monitoring;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
    }

    private void report(MessageExchange messageExchange) {
        this.monitoring_util.addMessage(messageExchange.getExchangeId(), messageExchange, this.showMessageContent);
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws Exception {
        this.log.call();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("router")) {
            if (!RouterService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterService.class.getName());
            }
            this.router = (RouterService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("router");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("router")) {
            return this.router;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("router")) {
            this.router = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

