/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.ws.client;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.ow2.petals.kernel.ws.api.ArtifactRepositoryService;
import org.ow2.petals.kernel.ws.api.DeploymentService;
import org.ow2.petals.kernel.ws.api.EndpointService;
import org.ow2.petals.kernel.ws.api.InformationService;
import org.ow2.petals.kernel.ws.api.InstallationService;
import org.ow2.petals.kernel.ws.api.JBIArtefactsService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.RuntimeService;
import org.ow2.petals.kernel.ws.api.ServiceAssemblyStateService;
import org.ow2.petals.kernel.ws.api.TopologyService;
import org.ow2.petals.kernel.ws.client.PetalsClient;
import org.ow2.petals.kernel.ws.client.WebServiceHelper;

public class CXFPetalsClient
implements PetalsClient {
    private String baseURL;
    private ArtifactRepositoryService artifactRepositoryService;
    private ServiceAssemblyStateService serviceAssemblyStateService;
    private DeploymentService deploymentService;
    private EndpointService endpointService;
    private InformationService informationService;
    private InstallationService installationService;
    private JBIArtefactsService jbiArtefactsService;
    private RuntimeService runtimeService;
    private TopologyService topologyService;
    private long timeout = 30000L;

    public CXFPetalsClient(String baseURL) {
        this.baseURL = baseURL;
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
    }

    public void init(long timeout) throws PEtALSWebServiceException {
        if (timeout >= 0L) {
            this.timeout = timeout;
        }
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(RuntimeService.class);
        factory.setAddress(this.baseURL + WebServiceHelper.getWebServiceName(RuntimeService.class));
        this.runtimeService = (RuntimeService)factory.create();
        this.setTimeOut(this.runtimeService);
        factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(ArtifactRepositoryService.class);
        factory.setAddress(this.baseURL + WebServiceHelper.getWebServiceName(ArtifactRepositoryService.class));
        this.artifactRepositoryService = (ArtifactRepositoryService)factory.create();
        this.setTimeOut(this.artifactRepositoryService);
        factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(ServiceAssemblyStateService.class);
        factory.setAddress(this.baseURL + WebServiceHelper.getWebServiceName(ServiceAssemblyStateService.class));
        this.serviceAssemblyStateService = (ServiceAssemblyStateService)factory.create();
        this.setTimeOut(this.serviceAssemblyStateService);
        factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(DeploymentService.class);
        factory.setAddress(this.baseURL + WebServiceHelper.getWebServiceName(DeploymentService.class));
        this.deploymentService = (DeploymentService)factory.create();
        this.setTimeOut(this.deploymentService);
        factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(EndpointService.class);
        factory.setAddress(this.baseURL + WebServiceHelper.getWebServiceName(EndpointService.class));
        this.endpointService = (EndpointService)factory.create();
        this.setTimeOut(this.endpointService);
        factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(InformationService.class);
        factory.setAddress(this.baseURL + WebServiceHelper.getWebServiceName(InformationService.class));
        this.informationService = (InformationService)factory.create();
        this.setTimeOut(this.informationService);
        factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(InstallationService.class);
        factory.setAddress(this.baseURL + WebServiceHelper.getWebServiceName(InstallationService.class));
        this.installationService = (InstallationService)factory.create();
        this.setTimeOut(this.installationService);
        factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(JBIArtefactsService.class);
        factory.setAddress(this.baseURL + WebServiceHelper.getWebServiceName(JBIArtefactsService.class));
        this.jbiArtefactsService = (JBIArtefactsService)factory.create();
        this.setTimeOut(this.jbiArtefactsService);
        factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(ServiceAssemblyStateService.class);
        factory.setAddress(this.baseURL + WebServiceHelper.getWebServiceName(ServiceAssemblyStateService.class));
        this.serviceAssemblyStateService = (ServiceAssemblyStateService)factory.create();
        this.setTimeOut(this.serviceAssemblyStateService);
        factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(TopologyService.class);
        factory.setAddress(this.baseURL + WebServiceHelper.getWebServiceName(TopologyService.class));
        this.topologyService = (TopologyService)factory.create();
        this.setTimeOut(this.topologyService);
    }

    private void setTimeOut(Object service) {
        Client client = ClientProxy.getClient((Object)service);
        if (client != null) {
            HTTPConduit conduit = (HTTPConduit)client.getConduit();
            HTTPClientPolicy policy = new HTTPClientPolicy();
            policy.setConnectionTimeout(this.timeout);
            policy.setReceiveTimeout(this.timeout);
            conduit.setClient(policy);
        }
    }

    public ArtifactRepositoryService getArtifactRepositoryService() {
        return this.artifactRepositoryService;
    }

    public ServiceAssemblyStateService getAssemblyStateService() {
        return this.serviceAssemblyStateService;
    }

    public DeploymentService getDeploymentService() {
        return this.deploymentService;
    }

    public EndpointService getEndpointService() {
        return this.endpointService;
    }

    public InformationService getInformationService() {
        return this.informationService;
    }

    public InstallationService getInstallationService() {
        return this.installationService;
    }

    public JBIArtefactsService getJbiArtefactsService() {
        return this.jbiArtefactsService;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public TopologyService getTopologyService() {
        return this.topologyService;
    }

    public String getBaseURL() {
        return this.baseURL;
    }
}

