/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.ow2.petals.registry.api.config.ConfigurationLoader;
import org.ow2.petals.registry.api.config.PropertiesConfigurationLoader;

public class ConfigurationLoaderFactory {
    private static Map<Type, ConfigurationLoader> loaders = new HashMap<Type, ConfigurationLoader>();

    public static final ConfigurationLoader getLoader(File configurationFile) {
        ConfigurationLoader loader = null;
        if (configurationFile != null && (configurationFile.getName().endsWith(".properties") || configurationFile.getName().endsWith(".cfg"))) {
            loader = ConfigurationLoaderFactory.getLoader(Type.PROPERTIES);
        }
        return loader;
    }

    public static final ConfigurationLoader getLoader(Type type) {
        return loaders.get((Object)type);
    }

    static {
        loaders.put(Type.PROPERTIES, new PropertiesConfigurationLoader());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PROPERTIES,
        XML;

    }
}

