/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.ow2.petals.registry.api.config.PropertiesTopologyLoader;
import org.ow2.petals.registry.api.config.TopologyLoader;

public class TopologyLoaderFactory {
    private static Map<Type, TopologyLoader> loaders = new HashMap<Type, TopologyLoader>();

    public static final TopologyLoader getLoader(File topologyFile) {
        TopologyLoader loader = null;
        if (topologyFile != null && (topologyFile.getName().endsWith(".properties") || topologyFile.getName().endsWith(".cfg"))) {
            loader = TopologyLoaderFactory.getLoader(Type.PROPERTIES);
        }
        return loader;
    }

    public static final TopologyLoader getLoader(Type type) {
        return loaders.get((Object)type);
    }

    static {
        loaders.put(Type.PROPERTIES, new PropertiesTopologyLoader());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PROPERTIES,
        XML;

    }
}

